/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.EntityActionProvider;
import moe.plushie.armourers_workshop.core.client.animation.AnimationContext;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.data.EntityAction;
import moe.plushie.armourers_workshop.core.data.EntityActionSet;
import moe.plushie.armourers_workshop.core.data.EntityActionTarget;
import moe.plushie.armourers_workshop.core.data.EntityActions;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.TickUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class AnimationManager {
    public static final AnimationManager NONE = new AnimationManager();
    private final HashMap<BakedSkin, Entry> allEntries = new HashMap();
    private final HashMap<BakedSkin, Entry> activeEntries = new HashMap();
    private final ArrayList<Entry> triggerableEntries = new ArrayList();
    private final ArrayList<Pair<AnimationController.PlayState, Runnable>> removeOnCompletion = new ArrayList();
    private EntityActionSet lastActionSet;

    public static AnimationManager of(Entity entity) {
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null) {
            return renderData.getAnimationManager();
        }
        return null;
    }

    public static AnimationManager of(BlockEntity blockEntity) {
        BlockEntityRenderData renderData = BlockEntityRenderData.of(blockEntity);
        if (renderData != null) {
            return renderData.getAnimationManager();
        }
        return null;
    }

    public void load(Map<SkinDescriptor, BakedSkin> skins) {
        HashMap<BakedSkin, Entry> expiredEntries = new HashMap<BakedSkin, Entry>(this.allEntries);
        skins.forEach((key, skin) -> {
            expiredEntries.remove(skin);
            this.allEntries.computeIfAbsent((BakedSkin)skin, x$0 -> new Entry((BakedSkin)x$0));
        });
        expiredEntries.forEach((key, entry) -> {
            this.allEntries.remove(key);
            entry.stop();
        });
        this.rebuildTriggerableEntities();
        this.setChanged();
    }

    public void active(Map<SkinDescriptor, BakedSkin> skins) {
        HashMap<BakedSkin, Entry> expiredEntries = new HashMap<BakedSkin, Entry>(this.activeEntries);
        skins.forEach((key, skin) -> {
            Entry entry = (Entry)expiredEntries.remove(skin);
            if (entry != null) {
                return;
            }
            entry = this.allEntries.get(skin);
            if (entry == null) {
                return;
            }
            this.activeEntries.put((BakedSkin)skin, entry);
            entry.autoplay();
        });
        expiredEntries.forEach((key, entry) -> {
            this.activeEntries.remove(key);
            entry.stop();
        });
    }

    public void tick(Object source, float animationTicks) {
        Entity entity;
        EntityActionSet actionSet;
        if (!this.removeOnCompletion.isEmpty()) {
            Iterator<Pair<AnimationController.PlayState, Runnable>> iterator = this.removeOnCompletion.iterator();
            while (iterator.hasNext()) {
                Pair<AnimationController.PlayState, Runnable> entry2 = iterator.next();
                AnimationController.PlayState state = (AnimationController.PlayState)entry2.getKey();
                state.tick(animationTicks);
                if (!state.isCompleted()) continue;
                iterator.remove();
                ((Runnable)entry2.getRight()).run();
            }
        }
        if (!this.triggerableEntries.isEmpty() && source instanceof Entity && (actionSet = EntityActionProvider.getActionSet(entity = (Entity)source)) != null && !actionSet.equals(this.lastActionSet)) {
            this.debugLog("{} action did change: {}", entity, actionSet);
            this.triggerableEntries.forEach(entry -> entry.autoplay(actionSet, animationTicks));
            this.lastActionSet = actionSet.copy();
        }
    }

    public void play(String name, float atTime, int playCount) {
        for (Entry entry : this.activeEntries.values()) {
            for (AnimationController animationController : entry.getAnimationControllers()) {
                if (!name.equals(animationController.getName())) continue;
                entry.play(animationController, atTime, playCount);
            }
        }
    }

    public void stop(String name) {
        for (Entry entry : this.activeEntries.values()) {
            for (AnimationController animationController : entry.getAnimationControllers()) {
                if (!name.isEmpty() && !name.equals(animationController.getName())) continue;
                entry.stop(animationController);
            }
        }
    }

    public void map(String from, String to) {
        this.allEntries.forEach((skin, entry) -> entry.map(from, to));
        this.rebuildTriggerableEntities();
        this.setChanged();
    }

    public void setChanged() {
        this.lastActionSet = null;
    }

    public AnimationContext getAnimationContext(BakedSkin skin) {
        Entry entry = this.allEntries.get(skin);
        if (entry != null) {
            return entry;
        }
        return skin.getAnimationContext();
    }

    private void rebuildTriggerableEntities() {
        this.triggerableEntries.clear();
        this.triggerableEntries.addAll(ObjectUtils.filter(this.allEntries.values(), Entry::hasTriggerableAnimation));
    }

    protected void debugLog(String message, Object ... arguments) {
        if (ModConfig.Client.enableAnimationDebug) {
            ModLog.debug(message, arguments);
        }
    }

    public class Entry
    extends AnimationContext {
        protected final List<AnimationController> animationControllers;
        protected final List<TriggerableController> triggerableControllers;
        protected final HashMap<String, String> actionToName;
        protected TriggerableController playing;
        protected boolean isLocking;

        public Entry(BakedSkin skin) {
            super(skin.getAnimationContext());
            this.triggerableControllers = new ArrayList<TriggerableController>();
            this.actionToName = new HashMap();
            this.animationControllers = skin.getAnimationControllers();
            this.rebuildTriggerableControllers();
        }

        public void map(String action, String newName) {
            if (action.equals(newName) || newName.isEmpty()) {
                this.actionToName.remove(action);
            } else {
                this.actionToName.put(action, newName);
            }
            this.rebuildTriggerableControllers();
        }

        public void autoplay() {
            this.animationControllers.stream().filter(AnimationController::isParallel).forEach(it -> this.startPlay((AnimationController)it, TickUtils.animationTicks(), 0));
        }

        public void autoplay(EntityActionSet actionSet, float atTime) {
            if (this.isLocking && this.playing != null) {
                return;
            }
            TriggerableController oldValue = this.playing;
            TriggerableController newValue = this.findTriggerableController(actionSet);
            if (oldValue == newValue) {
                return;
            }
            if (oldValue != null) {
                this.stopPlayIfNeeded(oldValue.animationController);
            }
            this.isLocking = false;
            this.playing = newValue;
            if (newValue != null) {
                this.startPlay(newValue.animationController, atTime, newValue.getPlayCount());
            }
            this.applyTransiting(oldValue, newValue, atTime);
        }

        public void play(AnimationController animationController, float atTime, int playCount) {
            if (animationController.isParallel()) {
                this.startPlay(animationController, atTime, playCount);
                return;
            }
            TriggerableController newValue = this.findTriggerableController(animationController);
            TriggerableController oldValue = this.playing;
            if (newValue == null || newValue == oldValue) {
                return;
            }
            if (oldValue != null) {
                this.stopPlayIfNeeded(oldValue.animationController);
            }
            this.isLocking = true;
            this.playing = newValue;
            this.startPlay(newValue.animationController, atTime, playCount);
            this.applyTransiting(oldValue, newValue, atTime);
        }

        public void stop(AnimationController animationController) {
            AnimationController.PlayState playState = (AnimationController.PlayState)this.playStates.get(animationController);
            if (playState == null) {
                return;
            }
            if (animationController.isParallel()) {
                this.stopPlayIfNeeded(animationController);
                return;
            }
            TriggerableController oldValue = this.playing;
            if (oldValue == null || oldValue.animationController != animationController) {
                return;
            }
            this.playing = null;
            this.isLocking = false;
            this.stopPlayIfNeeded(animationController);
            AnimationManager.this.setChanged();
        }

        public void stop() {
            this.animationControllers.forEach(this::stop);
        }

        public List<AnimationController> getAnimationControllers() {
            return this.animationControllers;
        }

        public boolean hasTriggerableAnimation() {
            return !this.triggerableControllers.isEmpty();
        }

        private void startPlay(AnimationController animationController, float atTime, int playCount) {
            this.stopPlayIfNeeded(animationController);
            AnimationController.PlayState newPlayState = new AnimationController.PlayState(animationController, atTime, playCount);
            this.playStates.put(animationController, newPlayState);
            AnimationManager.this.debugLog("start play {}", animationController);
            if (newPlayState.getPlayCount() > 0) {
                AnimationManager.this.removeOnCompletion.add((Pair<AnimationController.PlayState, Runnable>)Pair.of((Object)newPlayState, () -> this.stop(animationController)));
            }
        }

        private void stopPlayIfNeeded(AnimationController animationController) {
            AnimationController.PlayState oldPlayState = (AnimationController.PlayState)this.playStates.remove(animationController);
            if (oldPlayState != null) {
                AnimationManager.this.debugLog("stop play {}", animationController);
                AnimationManager.this.removeOnCompletion.removeIf(it -> it.getLeft() == oldPlayState);
            }
        }

        private void applyTransiting(TriggerableController from, TriggerableController to, float atTime) {
            ModLog.debug("start transiting: {} => {}", from, to);
        }

        private String resolveMappingName(String name) {
            for (Map.Entry<String, String> entry : this.actionToName.entrySet()) {
                if (entry.getValue().equals(name)) {
                    return entry.getKey();
                }
                if (!entry.getKey().equals(name)) continue;
                return "redirected:" + name;
            }
            return name;
        }

        private TriggerableController findTriggerableController(EntityActionSet tracker) {
            for (TriggerableController entry : this.triggerableControllers) {
                if (!entry.isIdle && !entry.test(tracker)) continue;
                return entry;
            }
            return null;
        }

        private TriggerableController findTriggerableController(AnimationController animationController) {
            for (TriggerableController entry : this.triggerableControllers) {
                if (entry.animationController != animationController) continue;
                return entry;
            }
            return null;
        }

        private void rebuildTriggerableControllers() {
            ArrayList<TriggerableController> newValues = new ArrayList<TriggerableController>();
            for (AnimationController animationController : this.animationControllers) {
                if (animationController.isParallel()) continue;
                String name = this.resolveMappingName(animationController.getName());
                TriggerableController controller = new TriggerableController(name, animationController);
                newValues.add(controller);
            }
            newValues.sort(Comparator.comparingDouble(TriggerableController::getPriority).reversed());
            this.triggerableControllers.clear();
            this.triggerableControllers.addAll(newValues);
            if (this.playing == null) {
                return;
            }
            this.playing = this.findTriggerableController(this.playing.animationController);
        }
    }

    public static class TriggerableController {
        private final String name;
        private final EntityActionTarget target;
        private final AnimationController animationController;
        private final boolean isIdle;

        public TriggerableController(String name, AnimationController animationController) {
            this.name = name;
            this.target = EntityActions.by(name);
            this.animationController = animationController;
            this.isIdle = this.target.getActions().contains((Object)EntityAction.IDLE);
        }

        public boolean test(EntityActionSet actionSet) {
            int hit = 0;
            for (EntityAction action : this.target.getActions()) {
                if (!actionSet.contains(action)) {
                    return false;
                }
                ++hit;
            }
            return hit != 0;
        }

        public String getName() {
            return this.name;
        }

        public double getPriority() {
            return this.target.getPriority();
        }

        public int getPlayCount() {
            return this.target.getPlayCount();
        }

        public String toString() {
            return this.animationController.toString();
        }
    }
}

