/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.armature.IJointFilter;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelProvider;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.render.EntityRendererStorage;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager2;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class BakedArmatureTransformer {
    public static final BakedArmatureTransformer EMPTY = new BakedArmatureTransformer();
    private final Armature armature;
    private final ArmatureTransformer armatureTransformer;
    private final IJointTransform[] transforms;
    private final ArrayList<ArmaturePlugin> plugins = new ArrayList();
    private IJointFilter filter;

    private BakedArmatureTransformer() {
        this.armature = null;
        this.armatureTransformer = null;
        this.transforms = null;
    }

    public BakedArmatureTransformer(ArmatureTransformer armatureTransformer) {
        this.armature = armatureTransformer.getArmature();
        this.armatureTransformer = armatureTransformer;
        this.transforms = armatureTransformer.getTransforms();
    }

    public static BakedArmatureTransformer create(ArmatureTransformer transformer, EntityRenderer<?> entityRenderer) {
        if (transformer == null) {
            return null;
        }
        ArmatureTransformerContext context = transformer.getContext();
        ArrayList plugins = Lists.newArrayList((Object[])transformer.getPlugins());
        context.setEntityRenderer(entityRenderer);
        if (context.getEntityModel() == null && entityRenderer instanceof IModelProvider) {
            context.setEntityModel(((IModelProvider)entityRenderer).getModel(null));
        }
        plugins.removeIf(plugin -> !plugin.freeze());
        BakedArmatureTransformer armatureTransformer1 = new BakedArmatureTransformer(transformer);
        armatureTransformer1.setPlugins(plugins);
        return armatureTransformer1;
    }

    @Nullable
    public static BakedArmatureTransformer defaultBy(@Nullable Entity entity, @Nullable Model entityModel, @Nullable EntityRenderer<?> entityRenderer) {
        if (entity == null) {
            return null;
        }
        EntityType entityType = entity.m_6095_();
        if (entityRenderer == null) {
            entityRenderer = Minecraft.m_91087_().m_91290_().m_114382_(entity);
        }
        if (entityModel == null) {
            entityModel = BakedArmatureTransformer.getModel(entityRenderer);
        }
        return BakedArmatureTransformer.defaultBy(entityType, entityModel, entityRenderer);
    }

    public static BakedArmatureTransformer defaultBy(EntityType<?> entityType, Model entityModel, EntityRenderer<?> entityRenderer) {
        EntityRendererStorage storage = EntityRendererStorage.of(entityRenderer);
        return storage.computeTransformerIfAbsent(entityModel, it -> {
            Object model = ModelHolder.ofNullable(entityModel);
            ArmatureTransformer transformer = SkinRendererManager2.DEFAULT.getTransformer(entityType, (IModel)model);
            return BakedArmatureTransformer.create(transformer, entityRenderer);
        });
    }

    public void prepare(Entity entity, ArmaturePlugin.Context context) {
        for (ArmaturePlugin plugin : this.plugins) {
            plugin.prepare(entity, context);
        }
    }

    public void activate(Entity entity, ArmaturePlugin.Context context) {
        for (ArmaturePlugin plugin : this.plugins) {
            plugin.activate(entity, context);
        }
    }

    public void deactivate(Entity entity, ArmaturePlugin.Context context) {
        for (ArmaturePlugin plugin : this.plugins) {
            plugin.deactivate(entity, context);
        }
    }

    public void applyTo(BakedArmature bakedArmature) {
        if (bakedArmature.getArmature() == this.armature) {
            bakedArmature.setFilter(this.filter);
            bakedArmature.seTransforms(this.transforms);
        }
    }

    public void setPlugins(Collection<ArmaturePlugin> plugins) {
        this.plugins.clear();
        this.plugins.addAll(plugins);
    }

    public Collection<ArmaturePlugin> getPlugins() {
        return this.plugins;
    }

    public void setFilter(IJointFilter filter) {
        this.filter = filter;
    }

    public IJointFilter getFilter() {
        return this.filter;
    }

    public ArmatureTransformer getTransformer() {
        return this.armatureTransformer;
    }

    public Armature getArmature() {
        return this.armature;
    }

    private static EntityModel<?> getModel(EntityRenderer<?> entityRenderer) {
        if (entityRenderer instanceof RenderLayerParent) {
            RenderLayerParent layerParent = (RenderLayerParent)entityRenderer;
            return layerParent.m_7200_();
        }
        return null;
    }
}

