/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedCubeFace;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.transform.SkinPartTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.face.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.face.SkinCuller;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureModel;
import moe.plushie.armourers_workshop.core.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.texture.SkinPreviewData;
import moe.plushie.armourers_workshop.core.texture.SkyBox;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class BakedCubeQuads {
    private final HashMap<RenderType, CompressedList<BakedCubeFace>> splitFaces = new HashMap();
    private final OpenVoxelShape shape;
    private final ColorDescriptor colorInfo;

    public BakedCubeQuads(OpenVoxelShape shape, ColorDescriptor colorInfo) {
        this.shape = shape;
        this.colorInfo = colorInfo;
    }

    public static QuadsList<ISkinPartType> from(SkinPart part) {
        QuadsList<ISkinPartType> quads = new QuadsList<ISkinPartType>();
        SkinCubes data = part.getCubeData();
        OpenVoxelShape shape = data.getShape();
        Rectangle3i bounds = new Rectangle3i(shape.bounds());
        SkinCuller.cullFaces2(data, bounds, part.getType()).forEach((? super T result) -> {
            SkinTransform newTransform = SkinTransform.createTranslateTransform(new Vector3f(result.getOrigin()));
            OpenVoxelShape newShape = shape;
            if (result.getPartType() != part.getType()) {
                Rectangle3i fixedBounds = result.getBounds().offset(bounds.getOrigin());
                newShape = OpenVoxelShape.box(fixedBounds);
            }
            BakedCubeQuads newQuads = new BakedCubeQuads(newShape, new ColorDescriptor());
            newQuads.loadFaces(result.getFaces());
            quads.add(result.getPartType(), newTransform, newQuads);
        });
        return quads;
    }

    public static QuadsList<ISkinPartType> from(SkinPreviewData previewData) {
        QuadsList<ISkinPartType> allQuads = new QuadsList<ISkinPartType>();
        if (previewData == null) {
            return allQuads;
        }
        previewData.forEach((ISkinTransform transform, SkinCubes data) -> {
            OpenVoxelShape shape = data.getShape();
            Rectangle3i bounds = new Rectangle3i(shape.bounds());
            SkinCuller.cullFaces2(data, bounds, SkinPartTypes.BLOCK).forEach((? super T result) -> {
                BakedCubeQuads quad = new BakedCubeQuads(shape, new ColorDescriptor());
                quad.loadFaces(result.getFaces());
                allQuads.add(result.getPartType(), (ISkinTransform)transform, quad);
            });
        });
        return allQuads;
    }

    public static QuadsList<ISkinPartType> from(SkinPaintData paintData) {
        QuadsList<ISkinPartType> allQuads = new QuadsList<ISkinPartType>();
        if (paintData == null) {
            return allQuads;
        }
        for (Map.Entry entry : PlayerTextureModel.of(paintData.getWidth(), paintData.getHeight(), false).entrySet()) {
            SkyBox box = (SkyBox)entry.getValue();
            ArrayList<SkinCubeFace> faces = new ArrayList<SkinCubeFace>();
            box.forEach((TexturePos texture, int x, int y, int z, Direction dir) -> {
                PaintColor paintColor = PaintColor.of(paintData.getColor(texture));
                if (paintColor.getPaintType() == SkinPaintTypes.NONE) {
                    return;
                }
                Rectangle3f shape = new Rectangle3f(x, y, z, 1.0f, 1.0f, 1.0f);
                SkinTransform transform = SkinTransform.IDENTITY;
                faces.add(new SkinCubeFace(shape, transform, paintColor, 255, dir, null, SkinCubeTypes.SOLID));
            });
            if (faces.isEmpty()) continue;
            BakedCubeQuads quads = new BakedCubeQuads(OpenVoxelShape.box(box.getBounds()), new ColorDescriptor());
            quads.loadFaces(faces);
            allQuads.add((ISkinPartType)entry.getKey(), SkinTransform.IDENTITY, quads);
        }
        return allQuads;
    }

    public static BakedCubeQuads merge(BakedCubeQuads parent, List<Pair<ISkinTransform, BakedCubeQuads>> children) {
        if (children.isEmpty()) {
            return parent;
        }
        OpenVoxelShape mergedShape = parent.getShape().copy();
        children.forEach((? super T pair) -> {
            ISkinTransform transform = (ISkinTransform)pair.getKey();
            BakedCubeQuads child = (BakedCubeQuads)pair.getValue();
            if (child.getShape().isEmpty()) {
                return;
            }
            OpenVoxelShape shape = child.getShape().copy();
            OpenPoseStack poseStack = new OpenPoseStack();
            transform.apply(poseStack);
            shape.mul(poseStack.last().pose());
            mergedShape.add(shape);
        });
        if (!mergedShape.isEmpty()) {
            mergedShape.optimize();
        }
        BakedCubeQuads result = new BakedCubeQuads(mergedShape, parent.getColorInfo());
        parent.splitFaces.forEach((? super K key, ? super V value) -> result.splitFaces.put((RenderType)key, value.copy()));
        children.forEach((? super T pair) -> {
            ISkinTransform transform = (ISkinTransform)pair.getKey();
            BakedCubeQuads child = (BakedCubeQuads)pair.getValue();
            child.splitFaces.forEach((? super K key, ? super V value) -> result.splitFaces.computeIfAbsent((RenderType)key, CompressedList::new).addAll(transform, value));
        });
        return result;
    }

    public void forEach(BiConsumer<RenderType, CompressedList<BakedCubeFace>> action) {
        this.splitFaces.forEach(action);
    }

    private void loadFaces(Collection<SkinCubeFace> faces) {
        for (SkinCubeFace skinCubeFace : faces) {
            if (skinCubeFace.getPaintType() == SkinPaintTypes.NONE) continue;
            BakedCubeFace bakedFace = new BakedCubeFace(skinCubeFace);
            this.addSplitFace(bakedFace.getRenderType(), bakedFace);
            if (bakedFace.getRenderTypeVariants() != null) {
                bakedFace.getRenderTypeVariants().forEach((? super T renderType) -> this.addSplitFace((RenderType)renderType, bakedFace));
            }
            this.colorInfo.add(skinCubeFace.getColor());
        }
        for (CompressedList compressedList : this.splitFaces.values()) {
            compressedList.sort(Comparator.comparingInt(f -> f.getDirection().m_122411_()));
        }
    }

    private void addSplitFace(RenderType renderType, BakedCubeFace bakedFace) {
        this.splitFaces.computeIfAbsent(renderType, CompressedList::new).add(bakedFace);
    }

    public ColorDescriptor getColorInfo() {
        return this.colorInfo;
    }

    public OpenVoxelShape getShape() {
        return this.shape;
    }

    public int getFaceTotal() {
        int total = 0;
        for (CompressedList<BakedCubeFace> face : this.splitFaces.values()) {
            total += face.size();
        }
        return total;
    }

    public static class QuadsList<T> {
        private final ArrayList<Triple<T, ISkinTransform, BakedCubeQuads>> quads = new ArrayList();

        public void add(T partType, ISkinTransform partTransform, BakedCubeQuads quad) {
            this.quads.add(Triple.of(partType, (Object)partTransform, (Object)quad));
        }

        public void forEach(QuadsConsumer<T> consumer) {
            this.quads.forEach((Consumer<Triple<T, ISkinTransform, BakedCubeQuads>>)((Consumer<Triple>)pair -> consumer.accept(pair.getLeft(), (ISkinTransform)pair.getMiddle(), (BakedCubeQuads)pair.getRight())));
        }
    }

    public static class CompressedList<T> {
        private final RenderType renderType;
        private final ArrayList<T> values = new ArrayList();
        private final ArrayList<Pair<ISkinTransform, List<T>>> transformedValues = new ArrayList();

        public CompressedList(RenderType renderType) {
            this.renderType = renderType;
        }

        public void add(T face) {
            this.values.add(face);
        }

        public void addAll(ISkinTransform transform, CompressedList<T> compressedList) {
            this.transformedValues.add(Pair.of((Object)transform, compressedList.values));
            for (Pair<ISkinTransform, List<T>> transformedValue : compressedList.transformedValues) {
                SkinPartTransform combinedTransform = new SkinPartTransform();
                combinedTransform.addChild(transform);
                combinedTransform.addChild((ISkinTransform)transformedValue.getKey());
                this.transformedValues.add(Pair.of((Object)combinedTransform, (Object)((List)transformedValue.getRight())));
            }
        }

        public void sort(Comparator<? super T> comparator) {
            this.values.sort(comparator);
        }

        public void forEach(BiConsumer<ISkinTransform, List<T>> consumer) {
            consumer.accept(SkinTransform.IDENTITY, this.values);
            for (Pair<ISkinTransform, List<T>> transformedValue : this.transformedValues) {
                consumer.accept((ISkinTransform)transformedValue.getLeft(), (List)transformedValue.getRight());
            }
        }

        public int size() {
            int total = this.values.size();
            for (Pair<ISkinTransform, List<T>> transformedValue : this.transformedValues) {
                total += ((List)transformedValue.getRight()).size();
            }
            return total;
        }

        public RenderType renderType() {
            return this.renderType;
        }

        public CompressedList<T> copy() {
            CompressedList<T> list = new CompressedList<T>(this.renderType);
            list.values.addAll(this.values);
            list.transformedValues.addAll(this.transformedValues);
            return list;
        }
    }

    public static interface QuadsConsumer<T> {
        public void accept(T var1, ISkinTransform var2, BakedCubeQuads var3);
    }
}

