/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import com.google.common.collect.Range;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.action.ICanHeld;
import moe.plushie.armourers_workshop.api.action.ICanUse;
import moe.plushie.armourers_workshop.api.client.IBakedSkin;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.client.animation.AnimationContext;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.animation.AnimationEngine;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPartCombiner;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderHelper;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.core.data.cache.PrimaryKey;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.data.transform.SkinPartTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinWingsTransform;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkin
implements IBakedSkin {
    private final int id = ThreadUtils.nextId(BakedSkinPart.class);
    private final String identifier;
    private final Skin skin;
    private final ISkinType skinType;
    private final HashMap<Object, Rectangle3f> cachedBounds = new HashMap();
    private final HashMap<BlockPos, Rectangle3i> cachedBlockBounds = new HashMap();
    private final ArrayList<SkinWingsTransform> cachedWingsTransforms = new ArrayList();
    private final ArrayList<BakedItemTransform> cachedItemTransforms = new ArrayList();
    private final Range<Integer> useTickRange;
    private final List<BakedSkinPart> skinParts;
    private final AnimationContext skinAnimationContext;
    private final List<AnimationController> skinAnimationControllers;
    private final ColorDescriptor colorDescriptor;
    private final SkinUsedCounter usedCounter;
    private final ColorScheme colorScheme;
    private final BakedItemModel resolvedItemModel;
    private final Int2ObjectMap<ColorScheme> resolvedColorSchemes = new Int2ObjectOpenHashMap();

    public BakedSkin(String identifier, ISkinType skinType, ArrayList<BakedSkinPart> bakedParts, Skin skin, ColorScheme colorScheme, ColorDescriptor colorDescriptor, SkinUsedCounter usedCounter) {
        this.identifier = identifier;
        this.skin = skin;
        this.skinType = skinType;
        this.skinAnimationControllers = this.resolveAnimationControllers(bakedParts, skin.getAnimations());
        this.skinAnimationContext = AnimationContext.from(bakedParts);
        this.skinParts = BakedSkinPartCombiner.apply(bakedParts);
        this.colorScheme = colorScheme;
        this.colorDescriptor = colorDescriptor;
        this.usedCounter = usedCounter;
        this.useTickRange = this.getUseTickRange(this.skinParts);
        this.resolvedItemModel = this.resolveItemModel(this.skinParts, skin.getItemTransforms());
        this.loadBlockBounds(this.skinParts);
        this.loadPartTransforms(this.skinParts);
    }

    public void setupAnim(Entity entity, BakedArmature bakedArmature, SkinRenderContext context) {
        this.cachedItemTransforms.forEach(it -> it.setup(entity, context.getItemSource()));
        this.cachedWingsTransforms.forEach(it -> it.setup(entity, context.getAnimationTicks()));
        AnimationEngine.apply(entity, this, context.getAnimationTicks(), context.getAnimationManager().getAnimationContext(this));
        SkinRenderHelper.apply(entity, this, bakedArmature, context.getItemSource());
    }

    public ColorScheme resolve(Entity entity, ColorScheme scheme) {
        if (this.colorDescriptor.isEmpty()) {
            return ColorScheme.EMPTY;
        }
        ColorScheme resolvedColorScheme = (ColorScheme)this.resolvedColorSchemes.computeIfAbsent(entity.m_19879_(), k -> this.colorScheme.copy());
        if (PlaceholderManager.isPlaceholder(entity)) {
            IResourceLocation resolvedTexture = PlayerTextureLoader.getInstance().getTextureLocation(entity);
            if (!Objects.equals(resolvedColorScheme.getTexture(), resolvedTexture)) {
                resolvedColorScheme.setTexture(resolvedTexture);
            }
        }
        resolvedColorScheme.setReference(scheme);
        return resolvedColorScheme;
    }

    public int getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public ISkinType getType() {
        return this.skinType;
    }

    public List<BakedSkinPart> getParts() {
        return this.skinParts;
    }

    public SkinProperties getProperties() {
        return this.skin.getProperties();
    }

    public AnimationContext getAnimationContext() {
        return this.skinAnimationContext;
    }

    public List<AnimationController> getAnimationControllers() {
        return this.skinAnimationControllers;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public ColorDescriptor getColorDescriptor() {
        return this.colorDescriptor;
    }

    @Nullable
    public BakedItemModel getItemModel() {
        return this.resolvedItemModel;
    }

    public Range<Integer> getUseTickRange() {
        return this.useTickRange;
    }

    public SkinUsedCounter getUsedCounter() {
        return this.usedCounter;
    }

    public HashMap<BlockPos, Rectangle3i> getBlockBounds() {
        return this.cachedBlockBounds;
    }

    public Rectangle3f getRenderBounds(SkinItemSource itemSource) {
        Vector3f rotation = itemSource.getRotation();
        PrimaryKey key = PrimaryKey.of(rotation, (Object)itemSource.getTransformType());
        Rectangle3f bounds = this.cachedBounds.get(key);
        if (bounds != null) {
            return bounds;
        }
        MannequinEntity entity = PlaceholderManager.MANNEQUIN.get();
        OpenMatrix4f matrix = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        OpenVoxelShape shape = this.getRenderShape((Entity)entity, BakedArmature.defaultBy(this.skinType), itemSource);
        if (rotation != null) {
            matrix.rotate(new OpenQuaternionf(rotation.getX(), rotation.getY(), rotation.getZ(), true));
            shape.mul(matrix);
        }
        bounds = shape.bounds().copy();
        if (rotation != null) {
            Vector4f center = new Vector4f(bounds.getCenter());
            matrix.invert();
            center.transform(matrix);
            bounds.setX(center.x() - bounds.getWidth() / 2.0f);
            bounds.setY(center.y() - bounds.getHeight() / 2.0f);
            bounds.setZ(center.z() - bounds.getDepth() / 2.0f);
        }
        this.cachedBounds.put(key.copy(), bounds);
        return bounds;
    }

    private OpenVoxelShape getRenderShape(Entity entity, BakedArmature armature, SkinItemSource itemSource) {
        if (armature == null) {
            return OpenVoxelShape.empty();
        }
        SkinRenderContext context = new SkinRenderContext();
        context.setItemSource(itemSource);
        context.setTransformType(itemSource.getTransformType());
        context.setAnimationTicks(0.0f);
        this.setupAnim(entity, armature, context);
        return SkinRenderer.getShape(entity, armature, this, context.pose());
    }

    private void loadPartTransforms(List<BakedSkinPart> skinParts) {
        skinParts.forEach(part -> {
            SkinPartTransform transform = part.getTransform();
            if (part.getType() instanceof ICanHeld) {
                transform.insertChild(new BakedItemTransform((BakedSkinPart)part, this), 0);
            }
        });
        skinParts.forEach(it -> it.getTransform().getChildren().forEach(transform -> {
            ISkinTransform transform1;
            if (transform instanceof SkinWingsTransform) {
                transform1 = (SkinWingsTransform)transform;
                this.cachedWingsTransforms.add((SkinWingsTransform)transform1);
            }
            if (transform instanceof BakedItemTransform) {
                transform1 = (BakedItemTransform)transform;
                this.cachedItemTransforms.add((BakedItemTransform)transform1);
            }
        }));
    }

    private void loadBlockBounds(List<BakedSkinPart> skinParts) {
        if (this.skinType != SkinTypes.BLOCK) {
            return;
        }
        for (BakedSkinPart skinPart : skinParts) {
            HashMap<BlockPos, Rectangle3i> bounds = skinPart.getPart().getBlockBounds();
            if (bounds == null) continue;
            this.cachedBlockBounds.putAll(bounds);
        }
    }

    private Range<Integer> getUseTickRange(List<BakedSkinPart> skinParts) {
        int count = 0;
        int maxUseTick = Integer.MIN_VALUE;
        int minUseTick = Integer.MAX_VALUE;
        for (BakedSkinPart bakedPart : skinParts) {
            ISkinPartType iSkinPartType = bakedPart.getType();
            if (!(iSkinPartType instanceof ICanUse)) continue;
            ICanUse partType = (ICanUse)((Object)iSkinPartType);
            Range<Integer> range = partType.getUseRange();
            maxUseTick = Math.max(maxUseTick, (Integer)range.upperEndpoint());
            minUseTick = Math.min(minUseTick, (Integer)range.lowerEndpoint());
            ++count;
        }
        if (count == 0) {
            return Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        }
        return Range.closed((Comparable)Integer.valueOf(minUseTick), (Comparable)Integer.valueOf(maxUseTick));
    }

    private BakedItemModel resolveItemModel(List<BakedSkinPart> skinParts, SkinItemTransforms oldValue) {
        if (oldValue != null) {
            return BakedItemModel.from(this.resolveItemOverrides(skinParts), oldValue, false);
        }
        return null;
    }

    private List<String> resolveItemOverrides(List<BakedSkinPart> skinParts) {
        ArrayList<String> overrides = new ArrayList<String>();
        for (BakedSkinPart part : skinParts) {
            overrides.addAll(SkinUtils.getItemOverrides(part.getType()));
        }
        return overrides;
    }

    private List<AnimationController> resolveAnimationControllers(List<BakedSkinPart> skinParts, Collection<SkinAnimation> animations) {
        ArrayList<AnimationController> results = new ArrayList<AnimationController>();
        if (animations.isEmpty()) {
            return results;
        }
        HashMap namedParts = new HashMap();
        ObjectUtils.search(skinParts, BakedSkinPart::getChildren, part -> {
            ISkinPartType partType = part.getType();
            String partName = partType.getName();
            if (partType == SkinPartTypes.ADVANCED) {
                partName = part.getName();
            }
            namedParts.put(partName, part);
        });
        animations.forEach(animation -> {
            AnimationController controller = new AnimationController((SkinAnimation)animation, namedParts);
            results.add(controller);
        });
        results.removeIf(AnimationController::isEmpty);
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BakedSkin)) {
            return false;
        }
        BakedSkin that = (BakedSkin)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

