/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.client.bake.BakedCubeQuads;
import moe.plushie.armourers_workshop.core.client.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.transform.SkinPartTransform;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkinPart {
    private final int id = ThreadUtils.nextId(BakedSkinPart.class);
    private final SkinPart part;
    private final BakedCubeQuads quads;
    private final SkinPartTransform transform;
    private final ColorDescriptor descriptor;
    private final ArrayList<BakedSkinPart> children = new ArrayList();
    private float renderPolygonOffset;
    private boolean shouldRender = true;

    public BakedSkinPart(SkinPart part, SkinPartTransform transform, BakedCubeQuads quads) {
        this.part = part;
        this.quads = quads;
        this.transform = transform;
        this.descriptor = quads.getColorInfo();
        this.renderPolygonOffset = this.getType().getRenderPolygonOffset();
    }

    public void addPart(BakedSkinPart part) {
        this.children.add(part);
    }

    public void removePart(BakedSkinPart part) {
        this.children.remove(part);
    }

    @Nullable
    public Object requirements(ColorScheme scheme) {
        if (this.descriptor.isEmpty() || scheme.isEmpty()) {
            return null;
        }
        boolean needsEntityTexture = false;
        ArrayList<Object> requirements = new ArrayList<Object>();
        for (ISkinPaintType paintType : this.descriptor.getPaintTypes()) {
            if (paintType.getDyeType() != null) {
                IPaintColor resolvedColor = scheme.getResolvedColor(paintType);
                requirements.add(paintType.getId());
                requirements.add(resolvedColor);
                if (resolvedColor != null) {
                    paintType = resolvedColor.getPaintType();
                }
            }
            if (paintType != SkinPaintTypes.TEXTURE) continue;
            needsEntityTexture = true;
        }
        if (needsEntityTexture && PlayerTextureLoader.getInstance().getTextureModel(scheme.getTexture()) != null) {
            requirements.add(SkinPaintTypes.TEXTURE.getId());
            requirements.add(scheme.getTexture());
        }
        return requirements;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        String name = this.part.getName();
        if (name == null) {
            name = this.part.getType().getName();
        }
        return name;
    }

    public SkinPart getPart() {
        return this.part;
    }

    public ISkinPartType getType() {
        return this.part.getType();
    }

    public SkinPartTransform getTransform() {
        return this.transform;
    }

    public ColorDescriptor getColorInfo() {
        return this.quads.getColorInfo();
    }

    public OpenVoxelShape getRenderShape() {
        return this.quads.getShape();
    }

    public int getFaceTotal() {
        return this.quads.getFaceTotal();
    }

    public void setRenderPolygonOffset(float renderPolygonOffset) {
        this.renderPolygonOffset = renderPolygonOffset;
    }

    public float getRenderPolygonOffset() {
        return this.renderPolygonOffset;
    }

    public void setShouldRender(boolean shouldRender) {
        this.shouldRender = shouldRender;
    }

    public boolean isVisible() {
        return this.shouldRender;
    }

    public ArrayList<BakedSkinPart> getChildren() {
        return this.children;
    }

    public SkinProperties getProperties() {
        return this.part.getProperties();
    }

    public BakedCubeQuads getQuads() {
        return this.quads;
    }
}

