/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedCubeQuads;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.data.transform.SkinPartTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinWingsTransform;
import moe.plushie.armourers_workshop.init.ModDebugger;
import org.apache.commons.lang3.tuple.Pair;

public class BakedSkinPartCombiner {
    public static List<BakedSkinPart> apply(List<BakedSkinPart> skinParts) {
        if (ModDebugger.skinPartCombiner) {
            return skinParts;
        }
        ArrayList<BakedSkinPart> results = new ArrayList<BakedSkinPart>();
        for (BakedSkinPart skinPart : skinParts) {
            results.add(BakedSkinPartCombiner.clip(skinPart));
        }
        return results;
    }

    private static BakedSkinPart clip(BakedSkinPart rootPart) {
        if (rootPart.getChildren().isEmpty()) {
            return rootPart;
        }
        ArrayList<Node> restNodes = new ArrayList<Node>();
        ArrayList<Node> motionNodes = new ArrayList<Node>();
        Node rootNode = new Node(null, rootPart);
        for (Node node : rootNode.children) {
            node.freeze(motionNodes, restNodes);
        }
        ArrayList<Pair<ISkinTransform, BakedCubeQuads>> pendingQuads = new ArrayList<Pair<ISkinTransform, BakedCubeQuads>>();
        for (Node node : restNodes) {
            SkinPartTransform resolvedTransform = node.resolveTransform();
            BakedCubeQuads resolvedQuads = node.part.getQuads();
            pendingQuads.add((Pair<ISkinTransform, BakedCubeQuads>)Pair.of((Object)resolvedTransform, (Object)resolvedQuads));
        }
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (Node childNode : motionNodes) {
            SkinPartTransform transform = childNode.resolveTransform();
            BakedSkinPart part = BakedSkinPartCombiner.clip(childNode.part);
            arrayList.add(Pair.of((Object)transform, (Object)part));
        }
        BakedCubeQuads bakedCubeQuads = BakedCubeQuads.merge(rootPart.getQuads(), pendingQuads);
        BakedSkinPart resolvedPart = new BakedSkinPart(rootPart.getPart(), rootPart.getTransform(), bakedCubeQuads);
        for (Pair pair : arrayList) {
            SkinPartTransform transform = (SkinPartTransform)pair.getKey();
            BakedSkinPart childPart = (BakedSkinPart)pair.getValue();
            if (childPart.getTransform() == transform) {
                resolvedPart.addPart(childPart);
                continue;
            }
            BakedSkinPart childPart1 = new BakedSkinPart(childPart.getPart(), transform, childPart.getQuads());
            childPart.getChildren().forEach(childPart1::addPart);
            resolvedPart.addPart(childPart1);
        }
        return resolvedPart;
    }

    public static class Node {
        private final BakedSkinPart part;
        private final Node parent;
        private final ArrayList<Node> children = new ArrayList();

        private Node(Node parent, BakedSkinPart part) {
            this.parent = parent;
            this.part = part;
            for (BakedSkinPart childPart : part.getChildren()) {
                this.children.add(new Node(this, childPart));
            }
        }

        public SkinPartTransform resolveTransform() {
            if (this.parent == null) {
                return SkinPartTransform.IDENTITY;
            }
            SkinPartTransform childTransform = this.part.getTransform();
            SkinPartTransform parentTransform = this.parent.resolveTransform();
            if (parentTransform.isIdentity()) {
                return childTransform;
            }
            if (childTransform.isIdentity()) {
                return parentTransform;
            }
            SkinPartTransform mergedTransform = new SkinPartTransform();
            for (ISkinTransform transform : parentTransform.getChildren()) {
                mergedTransform.addChild(transform);
            }
            for (ISkinTransform transform : childTransform.getChildren()) {
                mergedTransform.addChild(transform);
            }
            return mergedTransform;
        }

        public void freeze(ArrayList<Node> motionNodes, ArrayList<Node> restNodes) {
            if (!this.freeze()) {
                motionNodes.add(this);
                return;
            }
            restNodes.add(this);
            for (Node child : this.children) {
                child.freeze(motionNodes, restNodes);
            }
        }

        private boolean freeze() {
            for (ISkinTransform transform : this.part.getTransform().getChildren()) {
                if (transform instanceof SkinWingsTransform) {
                    return false;
                }
                if (!(transform instanceof AnimatedTransform)) continue;
                return false;
            }
            return true;
        }
    }
}

