/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.api.library.ISkinLibraryListener;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.client.bake.BakedCubeQuads;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.data.DataTransformer;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.data.transform.SkinPartTransform;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.cube.impl.SkinCubesV0;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class SkinBakery
implements ISkinLibraryListener {
    private static final SkinBakery EMPTY = new SkinBakery();
    private static SkinBakery BAKERY;
    private final ArrayList<IBakeListener> listeners = new ArrayList();
    private final DataTransformer<String, BakedSkin, Skin> manager = new DataTransformer.Builder().thread("AW-SKIN-BK", 1).loadCount(ModConfig.Client.modelBakingThreadCount).transformCount(ModConfig.Client.modelBakingThreadCount).loader(this::loadSkin0).transformer(this::bakeSkin0).build();

    public static SkinBakery getInstance() {
        if (BAKERY != null) {
            return BAKERY;
        }
        return EMPTY;
    }

    public static void start() {
        if (BAKERY == null) {
            BAKERY = new SkinBakery();
            BAKERY.startListenLibraryChanges();
            ModLog.debug("start bakery", new Object[0]);
        }
    }

    public static void stop() {
        if (BAKERY != null) {
            BAKERY.stopListenLibraryChanges();
            SkinBakery.BAKERY.manager.shutdown();
            BAKERY = null;
            SkinVertexBufferBuilder.clearAllCache();
            ModLog.debug("stop bakery", new Object[0]);
        }
    }

    public static void clear() {
        if (BAKERY != null) {
            SkinBakery.BAKERY.manager.clear();
            SkinVertexBufferBuilder.clearAllCache();
        }
    }

    public void addListener(IBakeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IBakeListener listener) {
        this.listeners.remove(listener);
    }

    @Nullable
    public BakedSkin getSkin(String identifier) {
        if (identifier.isEmpty()) {
            return null;
        }
        Pair<BakedSkin, Exception> pair = this.manager.get(identifier);
        if (pair != null) {
            return (BakedSkin)pair.getKey();
        }
        return null;
    }

    @Nullable
    public BakedSkin loadSkin(String identifier, Ticket ticket) {
        if (identifier.isEmpty()) {
            return null;
        }
        Pair<BakedSkin, Exception> pair = this.manager.getOrLoad(identifier, ticket);
        if (pair != null) {
            return (BakedSkin)pair.getKey();
        }
        return null;
    }

    @Nullable
    public BakedSkin loadSkin(SkinDescriptor descriptor, Ticket ticket) {
        if (!descriptor.isEmpty()) {
            return this.loadSkin(descriptor.getIdentifier(), ticket);
        }
        return null;
    }

    public void loadSkin(String identifier, Ticket ticket, IResultHandler<BakedSkin> handler) {
        this.manager.load(identifier, ticket, handler);
    }

    private void startListenLibraryChanges() {
        SkinLibraryManager.getClient().addListener(this);
    }

    private void stopListenLibraryChanges() {
        SkinLibraryManager.getClient().removeListener(this);
    }

    @Override
    public void libraryDidChanges(ISkinLibrary library, ISkinLibrary.Difference difference) {
        RenderSystem.recordRenderCall(() -> {
            difference.getRemovedChanges().forEach(it -> this.invalidateSkin0(it.getSkinIdentifier()));
            difference.getUpdatedChanges().forEach(it -> this.invalidateSkin0(((ISkinLibrary.Entry)it.getKey()).getSkinIdentifier()));
        });
    }

    private void invalidateSkin0(String identifier) {
        SkinLoader.getInstance().removeSkin(identifier);
        this.manager.remove(identifier);
    }

    private void loadSkin0(String identifier, IResultHandler<Skin> complete) {
        SkinLoader.getInstance().loadSkin(identifier, complete);
    }

    private void bakeSkin0(String identifier, Skin skin, IResultHandler<BakedSkin> complete) {
        try {
            this.bakeSkin(identifier, skin, complete);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            complete.throwing(exception);
        }
    }

    private void bakeSkin(String identifier, Skin skin, IResultHandler<BakedSkin> complete) {
        ModLog.debug("'{}' => start baking skin", identifier);
        long startTime = System.currentTimeMillis();
        SkinUsedCounter usedCounter = new SkinUsedCounter();
        ArrayList<BakedSkinPart> rootParts = new ArrayList<BakedSkinPart>();
        ArrayList bakedParts = new ArrayList();
        ColorScheme scheme = new ColorScheme();
        ColorDescriptor colorInfo = new ColorDescriptor();
        this.eachPart(skin.getParts(), null, (parent, part) -> {
            ArrayList children = new ArrayList();
            BakedCubeQuads.from(part).forEach((partType, partTransform, quads) -> {
                SkinPart usedPart = part;
                if (usedPart.getType() != partType) {
                    usedPart = new SkinPart((ISkinPartType)partType, (Collection<SkinMarker>)Collections.emptyList(), new SkinCubesV0(0));
                }
                BakedSkinPart bakedPart = new BakedSkinPart(usedPart, new SkinPartTransform(usedPart, partTransform), quads);
                children.add(bakedPart);
                bakedParts.add(bakedPart);
                usedCounter.addFaceTotal(bakedPart.getFaceTotal());
            });
            BakedSkinPart mainChildPart = null;
            for (BakedSkinPart bakedPart : children) {
                if (parent != null) {
                    parent.addPart(bakedPart);
                } else {
                    rootParts.add(bakedPart);
                }
                if (bakedPart.getPart() != part) continue;
                mainChildPart = bakedPart;
            }
            usedCounter.add(part.getCubeData().getUsedCounter());
            return mainChildPart;
        });
        BakedCubeQuads.from(skin.getPaintData()).forEach((partType, partTransform, quads) -> {
            SkinPart part = new SkinPart((ISkinPartType)partType, (Collection<SkinMarker>)Collections.emptyList(), new SkinCubesV0(0));
            BakedSkinPart bakedPart = new BakedSkinPart(part, new SkinPartTransform(part, partTransform), quads);
            bakedPart.setRenderPolygonOffset(20.0f);
            bakedParts.add(bakedPart);
            rootParts.add(bakedPart);
        });
        if (skin.getSettings().isPreviewMode()) {
            BakedCubeQuads.from(skin.getPreviewData()).forEach((partType, partTransform, quads) -> {
                SkinPart part = new SkinPart((ISkinPartType)partType, (Collection<SkinMarker>)Collections.emptyList(), new SkinCubesV0(0));
                BakedSkinPart bakedPart = new BakedSkinPart(part, new SkinPartTransform(part, partTransform), quads);
                bakedPart.setRenderPolygonOffset(bakedParts.size());
                bakedParts.add(bakedPart);
                rootParts.add(bakedPart);
            });
        }
        ObjectUtils.search(bakedParts, BakedSkinPart::getChildren, bakedPart -> colorInfo.add(bakedPart.getColorInfo()));
        usedCounter.addPaints(colorInfo.getPaintTypes());
        long totalTime = System.currentTimeMillis() - startTime;
        BakedSkin bakedSkin = new BakedSkin(identifier, skin.getType(), rootParts, skin, scheme, colorInfo, usedCounter);
        ModLog.debug("'{}' => accept baked skin, time: {}ms", identifier, totalTime);
        complete.accept(bakedSkin);
        RenderSystem.recordRenderCall(() -> this.notifyBake(identifier, bakedSkin));
        if (totalTime < 250L) {
            this.sleep(100L);
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void notifyBake(String identifier, BakedSkin bakedSkin) {
        this.listeners.forEach(listener -> listener.didBake(identifier, bakedSkin));
    }

    private void eachPart(Collection<SkinPart> parts, BakedSkinPart parent, BiFunction<BakedSkinPart, SkinPart, BakedSkinPart> consumer) {
        for (SkinPart part : parts) {
            BakedSkinPart value = consumer.apply(parent, part);
            this.eachPart(part.getParts(), value, consumer);
        }
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface IBakeListener {
        public void didBake(String var1, BakedSkin var2);
    }
}

