/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.wardrobe;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeBaseSetting;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeDisplaySetting
extends SkinWardrobeBaseSetting {
    private final SkinWardrobe wardrobe;

    public SkinWardrobeDisplaySetting(SkinWardrobe wardrobe) {
        super("wardrobe.display_settings");
        this.wardrobe = wardrobe;
        this.setup();
    }

    private void setup() {
        this.setupOptionView(83, 27, UpdateWardrobePacket.Field.WARDROBE_ARMOUR_HEAD, "renderHeadArmour");
        this.setupOptionView(83, 47, UpdateWardrobePacket.Field.WARDROBE_ARMOUR_CHEST, "renderChestArmour");
        this.setupOptionView(83, 67, UpdateWardrobePacket.Field.WARDROBE_ARMOUR_LEGS, "renderLegArmour");
        this.setupOptionView(83, 87, UpdateWardrobePacket.Field.WARDROBE_ARMOUR_FEET, "renderFootArmour");
    }

    private void setupOptionView(int x, int y, UpdateWardrobePacket.Field<Boolean> property, String key) {
        UICheckBox checkBox = new UICheckBox(new CGRect(x, y, 185.0f, 10.0f));
        checkBox.setTitle(this.getDisplayText(key, new Object[0]));
        checkBox.setSelected(property.getOrDefault(this.wardrobe, true));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            UICheckBox checkBox1 = (UICheckBox)ObjectUtils.unsafeCast(c);
            NetworkManager.sendToServer(property.buildPacket(self.wardrobe, checkBox1.isSelected()));
        });
        this.addSubview(checkBox);
    }
}

