/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.wardrobe;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeBaseSetting;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeExtraSetting
extends SkinWardrobeBaseSetting {
    private final SkinWardrobe wardrobe;

    public SkinWardrobeExtraSetting(SkinWardrobe wardrobe) {
        super("wardrobe.man_extras");
        this.wardrobe = wardrobe;
        this.setup();
    }

    private void setup() {
        this.setupOptionView(83, 27, UpdateWardrobePacket.Field.MANNEQUIN_IS_CHILD, "label.isChild");
        this.setupOptionView(83, 47, UpdateWardrobePacket.Field.MANNEQUIN_EXTRA_RENDER, "label.isExtraRenders");
        this.setupOptionView(83, 67, UpdateWardrobePacket.Field.MANNEQUIN_IS_FLYING, "label.isFlying");
        this.setupOptionView(83, 87, UpdateWardrobePacket.Field.MANNEQUIN_IS_VISIBLE, "label.isVisible");
        this.setupOptionView(83, 107, UpdateWardrobePacket.Field.MANNEQUIN_IS_GHOST, "label.noclip");
    }

    private void setupOptionView(int x, int y, UpdateWardrobePacket.Field<Boolean> option, String key) {
        UICheckBox checkBox = new UICheckBox(new CGRect(x, y, 185.0f, 10.0f));
        checkBox.setTitle(this.getDisplayText(key, new Object[0]));
        checkBox.setSelected(option.getOrDefault(this.wardrobe, true));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            UICheckBox checkBox1 = (UICheckBox)ObjectUtils.unsafeCast(c);
            NetworkManager.sendToServer(option.buildPacket(self.wardrobe, checkBox1.isSelected()));
        });
        this.addSubview(checkBox);
    }
}

