/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.client.other.EntitySlotsHandler;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.BlockEntityRenderPatch;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BlockEntityRenderData
extends EntitySlotsHandler<BlockEntity> {
    private Object customTextureProvider;
    private BlockEntityRenderPatch<? super BlockEntity> renderPatch;

    public BlockEntityRenderData(BlockEntity blockEntity) {
        super(new EntitySlotsHandler.BlockEntityProvider(), new EntitySlotsHandler.WardrobeProvider());
        this.renderPatch = new BlockEntityRenderPatch(blockEntity);
        this.renderPatch.getRenderingContext().setAnimationManager(this.getAnimationManager());
    }

    @Nullable
    public static BlockEntityRenderData of(@Nullable BlockEntity entity) {
        if (entity != null) {
            return EntityDataStorage.of(entity).getRenderData().orElse(null);
        }
        return null;
    }

    public void tick(BlockEntity blockEntity) {
        this.tick(blockEntity, null);
    }

    public BlockEntityRenderPatch<? super BlockEntity> getRenderPatch() {
        return this.renderPatch;
    }

    public void setCustomTextureProvider(Object customTextureProvider) {
        this.customTextureProvider = customTextureProvider;
    }

    public Object getCustomTextureProvider() {
        return this.customTextureProvider;
    }
}

