/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import moe.plushie.armourers_workshop.api.client.IRenderedBuffer;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVertexArrayObject;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.buffer.BufferBuilder;
import moe.plushie.armourers_workshop.core.client.buffer.OutlineBufferBuilder;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.VertexArrayObject;
import moe.plushie.armourers_workshop.core.client.other.VertexBufferObject;
import moe.plushie.armourers_workshop.core.client.other.VertexIndexObject;
import moe.plushie.armourers_workshop.core.client.texture.TextureManager;
import moe.plushie.armourers_workshop.core.data.cache.CacheQueue;
import moe.plushie.armourers_workshop.core.data.cache.ObjectPool;
import moe.plushie.armourers_workshop.core.data.cache.ReferenceCounted;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.jetbrains.annotations.Nullable;

public class ConcurrentBufferCompiler {
    private static final ExecutorService QUEUE = ThreadUtils.newFixedThreadPool(2, "AW-SKIN-VB");
    private static final CacheQueue<Object, Group> CACHING = new CacheQueue(Duration.ofSeconds(30L), it -> RenderSystem.recordRenderCall(it::release));
    private static final VertexIndexObject INDEXER = new VertexIndexObject(4, 6, (builder, index) -> {
        builder.accept(index);
        builder.accept(index + 1);
        builder.accept(index + 2);
        builder.accept(index + 2);
        builder.accept(index + 3);
        builder.accept(index);
    });
    private ArrayList<Group> pendingTasks;

    public static void clearAllCache() {
        CACHING.clearAll();
    }

    @Nullable
    public Group compile(BakedSkinPart part, BakedSkin skin, ColorScheme scheme, boolean isOutline) {
        int options = this.createOptions(isOutline);
        Key key = Key.of(part.getId(), options, part.requirements(scheme));
        Group group = CACHING.get(key);
        if (group != null) {
            if (group.isCompiled()) {
                return group;
            }
            return null;
        }
        group = new Group(part, skin, options, scheme);
        CACHING.put(key.copy(), group);
        this.startBatch(group);
        return null;
    }

    private synchronized void startBatch(Group value) {
        ArrayList<Group> tasks = this.pendingTasks;
        if (tasks == null) {
            this.pendingTasks = tasks = new ArrayList();
            QUEUE.execute(this::compile);
        }
        tasks.add(value);
    }

    private synchronized ArrayList<Group> endBatch() {
        ArrayList<Group> tasks = this.pendingTasks;
        this.pendingTasks = null;
        return tasks;
    }

    private void compile() {
        ArrayList<Group> pendingTasks = this.endBatch();
        if (pendingTasks == null || pendingTasks.isEmpty()) {
            return;
        }
        OpenPoseStack poseStack1 = new OpenPoseStack();
        ArrayList<Pass> buildingTasks = new ArrayList<Pass>();
        for (Group task : pendingTasks) {
            BakedSkinPart part = task.part;
            ColorScheme scheme = task.scheme;
            HashSet usingTypes = new HashSet();
            ArrayList mergedTasks = new ArrayList();
            part.getQuads().forEach((renderType, quads) -> {
                BufferBuilder builder = this.createBufferBuilder((RenderType)renderType, quads.size(), task);
                quads.forEach((transform, faces) -> {
                    poseStack1.pushPose();
                    transform.apply(poseStack1);
                    faces.forEach(face -> face.render(part, scheme, 0xF000F0, OverlayTexture.f_118083_, poseStack1, builder));
                    poseStack1.popPose();
                });
                IRenderedBuffer renderedBuffer = builder.end();
                Pass compiledTask = new Pass(builder.getRenderType(), renderedBuffer, part.getRenderPolygonOffset(), part.getType(), task.isOutline());
                usingTypes.add(renderType);
                mergedTasks.add(compiledTask);
                buildingTasks.add(compiledTask);
            });
            task.mergedTasks = mergedTasks;
            task.usingTypes = ObjectUtils.flatMap(usingTypes, TextureManager.Entry::of);
        }
        this.link(pendingTasks, buildingTasks);
    }

    private void link(ArrayList<Group> cachedTasks, ArrayList<Pass> buildingTasks) {
        VertexIndexObject indexer = INDEXER;
        int totalRenderedBytes = 0;
        ArrayList<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>();
        for (Pass compiledTask : buildingTasks) {
            IRenderedBuffer renderedBuffer = compiledTask.bufferBuilder;
            VertexFormat format = renderedBuffer.format();
            ByteBuffer byteBuffer = renderedBuffer.vertexBuffer().duplicate();
            compiledTask.vertexCount = renderedBuffer.vertexCount();
            compiledTask.vertexOffset = totalRenderedBytes;
            compiledTask.bufferBuilder = null;
            compiledTask.format = format;
            byteBuffers.add(byteBuffer);
            totalRenderedBytes += byteBuffer.remaining();
            renderedBuffer.release();
            indexer.ensureCapacity(compiledTask.vertexCount * 2);
        }
        ByteBuffer mergedByteBuffer = ByteBuffer.allocateDirect(totalRenderedBytes);
        for (ByteBuffer byteBuffer : byteBuffers) {
            mergedByteBuffer.put(byteBuffer);
        }
        mergedByteBuffer.rewind();
        RenderSystem.recordRenderCall(() -> this.upload(mergedByteBuffer, cachedTasks));
    }

    private void upload(ByteBuffer byteBuffer, ArrayList<Group> cachedTasks) {
        VertexBufferObject vertexBuffer = new VertexBufferObject();
        vertexBuffer.upload(byteBuffer);
        for (Group cachedTask : cachedTasks) {
            cachedTask.bufferObject = vertexBuffer;
            cachedTask.retain();
        }
        vertexBuffer.release();
    }

    private int createOptions(boolean isOutline) {
        int options = 0;
        if (isOutline) {
            options |= 1;
        }
        return options;
    }

    private BufferBuilder createBufferBuilder(RenderType renderType, int total, Group task) {
        if (task.isOutline() && renderType.m_7280_().isPresent()) {
            return new OutlineBufferBuilder((RenderType)renderType.m_7280_().get(), total);
        }
        return new BufferBuilder(renderType, total);
    }

    public static class Key {
        protected static final ObjectPool<Key> POOL = ObjectPool.create(Key::new);
        private int p1;
        private int p2;
        private Object p3;
        private int hash;

        private Key set(int hash, int p1, int p2, Object p3) {
            this.hash = hash;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            return this;
        }

        public static Key of(int p1, int p2, Object p3) {
            int hash = p1;
            hash = 31 * hash + p2;
            hash = 31 * hash + (p3 == null ? 0 : p3.hashCode());
            return POOL.get().set(hash, p1, p2, p3);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key that = (Key)o;
            return this.p1 == that.p1 && this.p2 == that.p2 && Objects.equals(this.p3, that.p3);
        }

        public int hashCode() {
            return this.hash;
        }

        public Key copy() {
            return new Key().set(this.hash, this.p1, this.p2, this.p3);
        }
    }

    public static class Group
    extends ReferenceCounted {
        private final BakedSkinPart part;
        private final BakedSkin skin;
        private final int options;
        private final ColorScheme scheme;
        private ArrayList<Pass> mergedTasks;
        private ArrayList<ReferenceCounted> usingTypes;
        private VertexBufferObject bufferObject;
        private boolean isComplied = false;

        public Group(BakedSkinPart part, BakedSkin skin, int options, ColorScheme scheme) {
            this.skin = skin;
            this.part = part;
            this.options = options;
            this.scheme = scheme;
        }

        @Override
        protected void init() {
            RenderSystem.assertOnRenderThread();
            if (this.mergedTasks == null || this.usingTypes == null) {
                return;
            }
            this.bufferObject.retain();
            this.mergedTasks.forEach(it -> it.upload(this.bufferObject));
            this.usingTypes.forEach(ReferenceCounted::retain);
            this.isComplied = true;
        }

        @Override
        protected void dispose() {
            RenderSystem.assertOnRenderThread();
            if (this.bufferObject == null || this.mergedTasks == null || this.usingTypes == null) {
                return;
            }
            this.isComplied = false;
            this.usingTypes.forEach(ReferenceCounted::release);
            this.mergedTasks.forEach(Pass::close);
            this.bufferObject.release();
        }

        public List<Pass> getPasses() {
            return this.mergedTasks;
        }

        public boolean isEmpty() {
            return this.mergedTasks == null || this.mergedTasks.isEmpty();
        }

        public boolean isCompiled() {
            return this.isComplied;
        }

        public boolean isOutline() {
            return (this.options & 1) != 0;
        }
    }

    public static class Pass {
        final boolean isGrowing;
        final boolean isTranslucent;
        final boolean isOutline;
        final float polygonOffset;
        final ISkinPartType partType;
        final RenderType renderType;
        int vertexCount;
        int vertexOffset;
        IRenderedBuffer bufferBuilder;
        VertexFormat format;
        VertexArrayObject arrayObject;
        VertexBufferObject bufferObject;
        VertexIndexObject indexObject;
        boolean isCompiled = false;

        Pass(RenderType renderType, IRenderedBuffer bufferBuilder, float polygonOffset, ISkinPartType partType, boolean isOutline) {
            this.partType = partType;
            this.renderType = renderType;
            this.bufferBuilder = bufferBuilder;
            this.polygonOffset = polygonOffset;
            this.isGrowing = SkinRenderType.isGrowing(renderType);
            this.isTranslucent = SkinRenderType.isTranslucent(renderType);
            this.isOutline = isOutline;
        }

        public void upload(VertexBufferObject bufferObject) {
            this.arrayObject = AbstractVertexArrayObject.create(this.format, this.vertexOffset, bufferObject, INDEXER);
            this.bufferObject = bufferObject;
            this.indexObject = INDEXER;
            this.isCompiled = true;
        }

        public void close() {
            this.isCompiled = false;
            this.arrayObject.close();
            this.bufferObject = null;
            this.indexObject = null;
            this.arrayObject = null;
        }
    }
}

