/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentBufferCompiler;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentRenderingContext;
import moe.plushie.armourers_workshop.core.client.other.VertexArrayObject;
import moe.plushie.armourers_workshop.core.client.other.VertexBufferObject;
import moe.plushie.armourers_workshop.core.client.other.VertexIndexObject;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.data.cache.ObjectPool;
import moe.plushie.armourers_workshop.core.data.cache.ReferenceCounted;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import net.minecraft.client.renderer.RenderType;

public class ConcurrentRenderingPipeline {
    protected final ArrayList<Group> passGroups = new ArrayList();

    public void add(ConcurrentBufferCompiler.Group group, ConcurrentRenderingContext context) {
        Group pass = Group.POOL.get();
        IPoseStack poseStack = context.getPoseStack();
        IPoseStack modelViewStack = context.getModelViewStack();
        OpenPoseStack finalPoseStack = pass.poseStack;
        OpenMatrix4f lastPose = finalPoseStack.last().pose();
        OpenMatrix3f lastNormal = finalPoseStack.last().normal();
        lastPose.set(modelViewStack.last().pose());
        lastPose.multiply(poseStack.last().pose());
        lastNormal.set(poseStack.last().normal());
        lastNormal.invert();
        this.passGroups.add(pass.fill(group, context));
    }

    public void commit(Consumer<ShaderVertexObject> consumer) {
        for (Group pass : this.passGroups) {
            pass.forEach(consumer);
        }
        this.passGroups.clear();
    }

    public static class Group
    extends ReferenceCounted {
        private static final ObjectPool<Group> POOL = ObjectPool.create(Group::new);
        private final OpenPoseStack poseStack = new OpenPoseStack();
        private final ArrayList<Pass> pendingQueue = new ArrayList();
        private int usedCount = 0;
        private int totalCount = 0;
        private ConcurrentBufferCompiler.Group compiledGroup;

        public void forEach(Consumer<ShaderVertexObject> consumer) {
            for (int i = 0; i < this.usedCount; ++i) {
                Pass pass = this.pendingQueue.get(i);
                consumer.accept(pass);
            }
        }

        public Group fill(ConcurrentBufferCompiler.Group group, ConcurrentRenderingContext context) {
            this.usedCount = 0;
            this.compiledGroup = group;
            for (ConcurrentBufferCompiler.Pass mergedTask : group.getPasses()) {
                if (!context.shouldRenderOutline() && mergedTask.isOutline) continue;
                this.poll().fill(mergedTask, this.poseStack, context);
            }
            return this;
        }

        @Override
        protected void init() {
            if (this.compiledGroup != null) {
                this.compiledGroup.retain();
            }
        }

        @Override
        protected void dispose() {
            if (this.compiledGroup != null) {
                this.compiledGroup.release();
                this.compiledGroup = null;
            }
        }

        private Pass poll() {
            if (this.usedCount < this.totalCount) {
                return this.pendingQueue.get(this.usedCount++);
            }
            Pass pass = new Pass(this);
            this.pendingQueue.add(pass);
            ++this.totalCount;
            ++this.usedCount;
            return pass;
        }
    }

    public static class Pass
    implements ShaderVertexObject {
        int overlay;
        int lightmap;
        int outlineColor;
        float animationTicks;
        float polygonOffset;
        OpenPoseStack poseStack;
        ConcurrentBufferCompiler.Pass compiledTask;
        private final Group group;

        public Pass(Group group) {
            this.group = group;
        }

        public Pass fill(ConcurrentBufferCompiler.Pass compiledTask, OpenPoseStack poseStack, ConcurrentRenderingContext context) {
            this.compiledTask = compiledTask;
            this.poseStack = poseStack;
            this.overlay = context.getOverlay();
            this.lightmap = context.getLightmap();
            this.outlineColor = context.getOutlineColor();
            this.animationTicks = context.getAnimationTicks();
            this.polygonOffset = compiledTask.polygonOffset + context.getRenderPriority();
            this.retain();
            return this;
        }

        @Override
        public RenderType getType() {
            return this.compiledTask.renderType;
        }

        @Override
        public int getOffset() {
            return this.compiledTask.vertexOffset;
        }

        @Override
        public int getTotal() {
            return this.compiledTask.vertexCount;
        }

        @Override
        public VertexArrayObject getArrayObject() {
            return this.compiledTask.arrayObject;
        }

        @Override
        public VertexIndexObject getIndexObject() {
            return this.compiledTask.indexObject;
        }

        @Override
        public VertexBufferObject getBufferObject() {
            return this.compiledTask.bufferObject;
        }

        @Override
        public float getPolygonOffset() {
            return this.polygonOffset;
        }

        @Override
        public OpenPoseStack getPoseStack() {
            return this.poseStack;
        }

        @Override
        public VertexFormat getFormat() {
            if (this.compiledTask.format != null) {
                return this.compiledTask.format;
            }
            return this.compiledTask.renderType.m_110508_();
        }

        @Override
        public int getOverlay() {
            return this.overlay;
        }

        @Override
        public int getLightmap() {
            return this.lightmap;
        }

        @Override
        public int getOutlineColor() {
            return this.outlineColor;
        }

        @Override
        public boolean isGrowing() {
            return this.compiledTask.isGrowing;
        }

        @Override
        public boolean isTranslucent() {
            return this.compiledTask.isTranslucent;
        }

        @Override
        public boolean isOutline() {
            return this.compiledTask.isOutline;
        }

        public void retain() {
            this.group.retain();
        }

        @Override
        public void release() {
            this.group.release();
        }
    }
}

