/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class EntitySlot {
    protected final ItemStack itemStack;
    protected final SkinDescriptor descriptor;
    protected final BakedSkin bakedSkin;
    protected final ColorScheme bakedScheme;
    protected final Type slotType;
    protected final float renderPriority;
    protected final boolean keepOverlayColor;

    public EntitySlot(ItemStack itemStack, SkinDescriptor descriptor, BakedSkin bakedSkin, ColorScheme entityScheme, float renderPriority, Type slotType) {
        this.itemStack = itemStack;
        this.descriptor = descriptor;
        this.bakedSkin = bakedSkin;
        this.bakedScheme = EntitySlot.baking(descriptor.getColorScheme(), entityScheme, slotType);
        this.renderPriority = renderPriority;
        this.slotType = slotType;
        this.keepOverlayColor = bakedSkin.getProperties().get(SkinProperty.KEEP_OVERLAY_COLOR);
    }

    public static ColorScheme baking(ColorScheme skinScheme, ColorScheme entityScheme, Type slotType) {
        if (slotType == Type.IN_HELD) {
            return skinScheme;
        }
        if (skinScheme.isEmpty()) {
            return entityScheme;
        }
        if (entityScheme.isEmpty()) {
            return skinScheme;
        }
        ColorScheme bakedScheme = skinScheme.copy();
        bakedScheme.setReference(entityScheme);
        return bakedScheme;
    }

    public float getRenderPriority() {
        return this.renderPriority;
    }

    public BakedSkin getBakedSkin() {
        return this.bakedSkin;
    }

    public ColorScheme getBakedScheme() {
        return this.bakedScheme;
    }

    public SkinDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public int getOverrideOverlay(Entity entity) {
        if (!this.keepOverlayColor || !(entity instanceof LivingEntity)) {
            return OverlayTexture.f_118083_;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        int u = OverlayTexture.m_118088_((float)0.0f);
        int v = OverlayTexture.m_118096_((livingEntity.f_20916_ > 0 || livingEntity.f_20919_ > 0 ? 1 : 0) != 0);
        return OverlayTexture.m_118093_((int)u, (int)v);
    }

    public static enum Type {
        IN_HELD,
        IN_EQUIPMENT,
        IN_WARDROBE,
        IN_CONTAINER;

    }
}

