/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.HashMap;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.resources.ResourceLocation.Constructor;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemModel;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinModelManager {
    static final SkinModelManager INSTANCE = new SkinModelManager();
    final ModelManager modelManager;
    final HashMap<ISkinPartType, BakedModel> cachedModels = new HashMap();
    final HashMap<ISkinPartType, BakedModel> cachedItemModels = new HashMap();

    SkinModelManager() {
        this.modelManager = Minecraft.m_91087_().m_91304_();
    }

    public static SkinModelManager getInstance() {
        return INSTANCE;
    }

    public BakedModel getModel(ISkinPartType partType, @Nullable BakedItemModel itemModel, ItemStack itemStack, Entity entity) {
        return this.getModel(partType, itemModel, itemStack, PropertyProvider.getLevel(entity), entity);
    }

    public BakedModel getModel(ISkinPartType partType, @Nullable BakedItemModel itemModel, ItemStack itemStack, @Nullable Level level, @Nullable Entity entity) {
        ClientLevel clientWorld = ObjectUtils.safeCast(level, ClientLevel.class);
        LivingEntity livingEntity = ObjectUtils.safeCast(entity, LivingEntity.class);
        if (itemModel != null) {
            return itemModel.resolve((BakedModel)itemModel, itemStack, clientWorld, livingEntity, 0);
        }
        BakedModel bakedModel = this.loadModel(partType);
        return bakedModel.m_7343_().m_173464_(bakedModel, itemStack, clientWorld, livingEntity, 0);
    }

    public BakedModel getMissingModel() {
        return this.modelManager.m_119409_();
    }

    private BakedModel loadModel(ISkinPartType partType) {
        BakedModel bakedModel = this.cachedModels.get(partType);
        if (bakedModel != null) {
            return bakedModel;
        }
        IResourceLocation modelId = ArmourersWorkshop.getCustomModel(partType.getRegistryName());
        bakedModel = this.modelManager.m_119422_(Constructor.create(ResourceLocation.class, modelId, "inventory"));
        if (partType != SkinPartTypes.UNKNOWN && bakedModel == this.getMissingModel()) {
            bakedModel = this.loadModel(SkinPartTypes.UNKNOWN);
        }
        this.cachedModels.put(partType, bakedModel);
        return bakedModel;
    }
}

