/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.google.common.collect.Range;
import moe.plushie.armourers_workshop.api.action.ICanUse;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class SkinRenderHelper {
    public static int getRenderCount(BakedSkin bakedSkin) {
        int count = 0;
        for (BakedSkinPart part : bakedSkin.getParts()) {
            if (!part.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public static void apply(Entity entity, BakedSkin bakedSkin, BakedArmature bakedArmature, SkinItemSource itemSource) {
        for (BakedSkinPart part : bakedSkin.getParts()) {
            boolean shouldRender = false;
            if (bakedArmature != null && bakedArmature.getTransform(part) != null) {
                shouldRender = true;
            }
            if (shouldRender) {
                shouldRender = SkinRenderHelper.shouldRenderPart(entity, part, bakedSkin, itemSource);
            }
            part.setShouldRender(shouldRender);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldRenderPart(Entity entity, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinItemSource itemSource) {
        ISkinPartType partType = bakedPart.getType();
        if (partType == SkinPartTypes.ITEM_FISHING_HOOK) {
            return SkinRenderHelper.isHookEntity(entity);
        }
        if (partType == SkinPartTypes.ITEM_FISHING_ROD1) {
            if (!(entity instanceof Player)) return false;
            Player player = (Player)entity;
            if (player.f_36083_ == null) return false;
            return true;
        }
        if (partType == SkinPartTypes.ITEM_FISHING_ROD) {
            if (SkinRenderHelper.isHookEntity(entity)) {
                return false;
            }
            if (!(entity instanceof Player)) return true;
            Player player = (Player)entity;
            if (player.f_36083_ == null) return true;
            return false;
        }
        if (partType == SkinPartTypes.ITEM_ARROW) {
            if (SkinRenderHelper.isArrowEntity(entity)) {
                return true;
            }
            if (itemSource.getTransformType() != AbstractItemTransformType.NONE) return false;
            if (bakedPart.getChildren().size() != 1) return false;
            return true;
        }
        if (SkinRenderHelper.isArrowEntity(entity)) {
            return false;
        }
        if (SkinRenderHelper.isHookEntity(entity)) {
            return false;
        }
        if (!(partType instanceof ICanUse)) return true;
        ICanUse canUse = (ICanUse)((Object)partType);
        if (!(entity instanceof LivingEntity)) return true;
        LivingEntity livingEntity = (LivingEntity)entity;
        int useTick = SkinRenderHelper.getUseTick(livingEntity, itemSource.getItem());
        Range<Integer> useRange = canUse.getUseRange();
        Range<Integer> tickRange = bakedSkin.getUseTickRange();
        return useRange.contains((Comparable)Integer.valueOf(MathUtils.clamp(useTick, (Integer)tickRange.lowerEndpoint(), (Integer)tickRange.upperEndpoint())));
    }

    private static boolean isHookEntity(Entity entity) {
        return entity instanceof FishingHook;
    }

    private static boolean isArrowEntity(Entity entity) {
        if (entity instanceof ThrownTrident) {
            return false;
        }
        return entity instanceof AbstractArrow;
    }

    public static int getUseTick(LivingEntity entity, ItemStack itemStack) {
        if (entity.m_21211_() == itemStack) {
            return entity.m_21252_();
        }
        if (CrossbowItem.m_40932_((ItemStack)itemStack)) {
            return 100;
        }
        return 0;
    }
}

