/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.apple.library.uikit.UIColor;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentBufferBuilder;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentBufferCompiler;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentRenderingContext;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentRenderingPipeline;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderObjectBuilder
implements ConcurrentBufferBuilder {
    protected final BakedSkin skin;
    protected final ConcurrentBufferCompiler compiler = new ConcurrentBufferCompiler();
    protected final ConcurrentRenderingPipeline pipeline = new ConcurrentRenderingPipeline();

    public SkinRenderObjectBuilder(BakedSkin skin) {
        this.skin = skin;
    }

    @Override
    public void addPart(BakedSkinPart part, BakedSkin skin, ColorScheme scheme, ConcurrentRenderingContext context) {
        if (ModDebugger.vbo) {
            this.drawWithoutVBO(part, skin, scheme, context);
            return;
        }
        this.draw(part, skin, scheme, false, context);
        if (context.shouldRenderOutline()) {
            this.draw(part, skin, scheme, true, context);
        }
    }

    @Override
    public void addShape(Vector3f origin, ConcurrentRenderingContext context) {
        ShapeTesselator.vector(origin, 16.0f, context.getPoseStack(), context.getBufferSource());
    }

    @Override
    public void addShape(OpenVoxelShape shape, UIColor color, ConcurrentRenderingContext context) {
        ShapeTesselator.stroke(shape.bounds(), color, context.getPoseStack(), context.getBufferSource());
    }

    @Override
    public void addShape(BakedArmature armature, ConcurrentRenderingContext context) {
        IBufferSource bufferSource = context.getBufferSource();
        IPoseStack poseStack = context.getPoseStack();
        IJointTransform[] transforms = armature.getTransforms();
        Armature armature1 = armature.getArmature();
        for (IJoint joint : armature1.allJoints()) {
            JointShape shape = armature1.getShape(joint.getId());
            IJointTransform transform = transforms[joint.getId()];
            if (ModDebugger.defaultArmature) {
                transform = armature1.getGlobalTransform(joint.getId());
            }
            if (shape == null || transform == null) continue;
            poseStack.pushPose();
            transform.apply(poseStack);
            ShapeTesselator.stroke(shape, ColorUtils.getPaletteColor(joint.getId()), poseStack, bufferSource);
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    public void endBatch(Consumer<ShaderVertexObject> consumer) {
        this.pipeline.commit(consumer);
    }

    private void draw(BakedSkinPart part, BakedSkin skin, ColorScheme scheme, boolean isOutline, ConcurrentRenderingContext context) {
        ConcurrentBufferCompiler.Group group = this.compiler.compile(part, skin, scheme, isOutline);
        if (group != null && !group.isEmpty() && part.isVisible()) {
            this.pipeline.add(group, context);
        }
    }

    private void drawWithoutVBO(BakedSkinPart part, BakedSkin skin, ColorScheme scheme, ConcurrentRenderingContext context) {
        IPoseStack poseStack = context.getPoseStack();
        IBufferSource bufferSource = context.getBufferSource();
        part.getQuads().forEach((renderType, quads) -> {
            IVertexConsumer builder = bufferSource.getBuffer((RenderType)renderType);
            quads.forEach((transform, faces) -> {
                poseStack.pushPose();
                transform.apply(poseStack);
                faces.forEach(face -> face.render(part, scheme, context.getLightmap(), context.getOverlay(), poseStack, builder));
                poseStack.popPose();
            });
        });
    }

    private void drawWithVBO(ConcurrentBufferCompiler.Group group, ConcurrentRenderingContext context) {
        ConcurrentRenderingPipeline pipeline1 = new ConcurrentRenderingPipeline();
        SkinVertexBufferBuilder.Pipeline pipeline2 = new SkinVertexBufferBuilder.Pipeline();
        pipeline1.add(group, context);
        pipeline1.commit(pipeline2::add);
        pipeline2.end();
    }
}

