/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.ModelView;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmaturePluginContext;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.BlockEntityRenderPatch;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinnableBlockRenderer<T extends SkinnableBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private final BakedArmature armature = new BakedArmature(Armatures.ANY);

    public SkinnableBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        BlockEntityRenderData renderData = BlockEntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        renderData.tick((BlockEntity)entity);
        List<EntitySlot> renderingTasks = renderData.getAllSkins();
        if (renderingTasks.isEmpty()) {
            return;
        }
        float f = 0.0625f;
        BlockState blockState = entity.m_58900_();
        OpenQuaternionf rotations = ((SkinnableBlockEntity)entity).getRenderRotations(blockState);
        BlockEntityRenderPatch<? super BlockEntity> renderPatch = renderData.getRenderPatch();
        MannequinEntity mannequinEntity = PlaceholderManager.MANNEQUIN.get();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.rotate(rotations);
        poseStack.scale(f, f, f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        renderPatch.activate((BlockEntity)entity, partialTicks, light, overlay, poseStack);
        DefaultArmaturePluginContext pluginContext = renderPatch.getPluginContext();
        SkinRenderContext renderingContext = renderPatch.getRenderingContext();
        renderingContext.setOverlay(pluginContext.getOverlay());
        renderingContext.setLightmap(pluginContext.getLightmap());
        renderingContext.setPartialTicks(pluginContext.getPartialTicks());
        renderingContext.setAnimationTicks(pluginContext.getAnimationTicks());
        renderingContext.setPoseStack(poseStack);
        renderingContext.setBufferSource(bufferSource);
        renderingContext.setModelViewStack(AbstractPoseStack.create(ModelView.getExtendedModelViewStack(RenderSystem.class)));
        for (EntitySlot entry : renderingTasks) {
            BakedSkin skin = entry.getBakedSkin();
            skin.setupAnim((Entity)mannequinEntity, this.armature, renderingContext);
            ColorScheme colorScheme = skin.resolve((Entity)mannequinEntity, entry.getBakedScheme());
            SkinRenderer.render((Entity)mannequinEntity, this.armature, skin, colorScheme, renderingContext);
            if (!ModDebugger.skinnable) continue;
            skin.getBlockBounds().forEach((pos, rect) -> {
                poseStack.pushPose();
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate((float)pos.m_123341_() * 16.0f, (float)pos.m_123342_() * 16.0f, (float)pos.m_123343_() * 16.0f);
                ShapeTesselator.stroke(rect, UIColor.RED, poseStack, bufferSource);
                poseStack.popPose();
            });
        }
        renderPatch.deactivate((BlockEntity)entity);
        poseStack.popPose();
        if (ModDebugger.skinnable) {
            BlockPos pos2 = entity.m_58899_();
            poseStack.pushPose();
            poseStack.translate(-pos2.m_123341_(), -pos2.m_123342_(), -pos2.m_123343_());
            ShapeTesselator.stroke(((SkinnableBlockEntity)entity).getRenderShape(blockState), UIColor.ORANGE, poseStack, bufferSource);
            poseStack.popPose();
        }
    }
}

