/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderState;
import moe.plushie.armourers_workshop.core.client.other.VertexArrayObject;
import moe.plushie.armourers_workshop.core.client.other.VertexIndexObject;
import moe.plushie.armourers_workshop.core.client.shader.ShaderUniforms;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL15;

@OnlyIn(value=Dist.CLIENT)
public abstract class Shader {
    private final Int2ObjectOpenHashMap<OpenMatrix4f> overlayMatrices = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<OpenMatrix4f> lightmapMatrices = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<Vector4f> outlineColors = new Int2ObjectOpenHashMap();
    private final SkinRenderState renderState = new SkinRenderState();

    public void begin() {
        RenderSystem.backupExtendedFog();
        RenderSystem.backupExtendedMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
        RenderSystem.setShaderFogEnd((float)Float.MAX_VALUE);
        RenderSystem.setExtendedMatrixFlags(128);
        ShaderUniforms.begin();
        if (ModDebugger.wireframeRender) {
            RenderSystem.polygonMode((int)1032, (int)6913);
        }
    }

    public void end() {
        if (ModDebugger.wireframeRender) {
            RenderSystem.polygonMode((int)1032, (int)6914);
        }
        RenderSystem.setExtendedMatrixFlags(0);
        ShaderUniforms.end();
        RenderSystem.restoreExtendedMatrix();
        RenderSystem.restoreExtendedFog();
    }

    protected void prepare(ShaderVertexGroup group) {
        this.renderState.save();
        RenderSystem.setExtendedTextureMatrix(group.getTextureMatrix(TickUtils.animationTicks()));
        RenderSystem.enablePolygonOffset();
    }

    protected void clean(ShaderVertexGroup group) {
        RenderSystem.disablePolygonOffset();
        VertexArrayObject.unbind();
        this.renderState.load();
    }

    public void apply(ShaderVertexGroup group, Runnable action) {
        this.prepare(group);
        action.run();
        this.clean(group);
    }

    public void render(ShaderVertexObject object) {
        OpenPoseStack.Pose entry = object.getPoseStack().last();
        RenderSystem.setExtendedOverlayTextureMatrix(this.getOverlayTextureMatrix(object));
        RenderSystem.setExtendedLightmapTextureMatrix(this.getLightmapTextureMatrix(object));
        RenderSystem.setExtendedColorModulator(this.getColorColorModulator(object));
        RenderSystem.setExtendedNormalMatrix(entry.normal());
        RenderSystem.setExtendedModelViewMatrix(entry.pose());
        RenderSystem.polygonOffset((float)0.0f, (float)(object.getPolygonOffset() * -1.0f));
        ShaderUniforms.getInstance().apply(this.getLastProgramId());
        this.drawElements(object, object.getArrayObject(), object.getIndexObject(), object.getTotal());
    }

    protected void drawElements(ShaderVertexObject vertexObject, VertexArrayObject arrayObject, VertexIndexObject indexObject, int count) {
        count += count / 2;
        arrayObject.bind();
        GL15.glDrawElements((int)4, (int)count, (int)indexObject.type().asGLType, (long)0L);
    }

    protected int getLastProgramId() {
        return this.renderState.lastProgramId();
    }

    protected OpenMatrix4f getOverlayTextureMatrix(ShaderVertexObject object) {
        if (object.getOverlay() == OverlayTexture.f_118083_) {
            return OpenMatrix4f.identity();
        }
        return (OpenMatrix4f)this.overlayMatrices.computeIfAbsent(object.getOverlay(), overlay -> {
            int u = overlay & 0xFFFF;
            int v = overlay >> 16 & 0xFFFF;
            OpenMatrix4f newValue = OpenMatrix4f.createScaleMatrix(0.0f, 0.0f, 0.0f);
            newValue.m03 = u;
            newValue.m13 = v;
            return newValue;
        });
    }

    protected OpenMatrix4f getLightmapTextureMatrix(ShaderVertexObject object) {
        if (object.isGrowing()) {
            return OpenMatrix4f.identity();
        }
        return (OpenMatrix4f)this.lightmapMatrices.computeIfAbsent(object.getLightmap(), lightmap -> {
            int u = lightmap & 0xFFFF;
            int v = lightmap >> 16 & 0xFFFF;
            OpenMatrix4f newValue = OpenMatrix4f.createScaleMatrix(0.0f, 0.0f, 0.0f);
            newValue.m03 = u;
            newValue.m13 = v;
            return newValue;
        });
    }

    protected Vector4f getColorColorModulator(ShaderVertexObject object) {
        if (object.isOutline()) {
            return this.getOutlineColor(object);
        }
        return Vector4f.ONE;
    }

    protected Vector4f getOutlineColor(ShaderVertexObject object) {
        return (Vector4f)this.outlineColors.computeIfAbsent(object.getOutlineColor() | 0xFF000000, color -> {
            float red = (float)ColorUtils.getRed(color) / 255.0f;
            float green = (float)ColorUtils.getGreen(color) / 255.0f;
            float blue = (float)ColorUtils.getBlue(color) / 255.0f;
            return new Vector4f(red, green, blue, 1.0f);
        });
    }
}

