/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.client.texture.TextureAnimationController;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShaderVertexGroup {
    public int maxVertexCount;
    private final RenderType renderType;
    private final TextureAnimationController animationController;
    private final ArrayList<ShaderVertexObject> objects = new ArrayList();

    public ShaderVertexGroup(RenderType renderType) {
        this.renderType = renderType;
        this.animationController = TextureAnimationController.of(renderType);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public OpenMatrix4f getTextureMatrix(float animationTicks) {
        return this.animationController.getTextureMatrix(animationTicks);
    }

    public int size() {
        return this.objects.size();
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public void add(ShaderVertexObject object) {
        this.objects.add(object);
    }

    public void clear() {
        this.objects.forEach(ShaderVertexObject::release);
        this.objects.clear();
        this.maxVertexCount = 0;
    }

    public void forEach(Consumer<ShaderVertexObject> consumer) {
        this.objects.forEach(consumer);
    }
}

