/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.data.IDataPackBuilder;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelHolder;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractSkinnableModel;
import moe.plushie.armourers_workshop.core.armature.ArmatureSerializers;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.armature.core.DefaultLayerArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.AllayBodyJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.AllayHeadJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.AllayWingJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.DefaultBabyJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.DefaultSkirtJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.FlatWingJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.modifier.HorseBodyJointModifier;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.ArrowModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.BoatModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.FishingModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.MinecartModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.TridentModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.VillagerModelArmaturePlugin;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import net.minecraft.client.model.Model;

public class SkinRendererManager2
extends ArmatureSerializers {
    public static final ArmatureTransformerManager DEFAULT = new DefaultArmatureTransformerManager();
    public static final ArmatureTransformerManager EPICFIGHT = new EpicFlightArmatureTransformerManager();
    private static final ImmutableMap<String, ArmatureTransformerManager> MANAGERS = ImmutableMap.builder().put((Object)"armourers_workshop:armature", (Object)DEFAULT).put((Object)"epicfight:armature", (Object)EPICFIGHT).build();

    public static void init() {
        SkinRendererManager2.registerModifiers();
        SkinRendererManager2.registerPlugins();
        SkinRendererManager2.registerRenderers();
        SkinRendererManager2.registerModels();
        DataPackManager.register(DataPackType.BUNDLED_DATA, "skin/transformers", SimpleLoader::new, SimpleLoader::clean, SimpleLoader::freeze, 0);
    }

    private static void registerModifiers() {
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/baby_head_apt", DefaultBabyJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/body_to_skirt", DefaultSkirtJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/body_to_flat_wing", FlatWingJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/apply_ally_head", AllayHeadJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/apply_ally_body", AllayBodyJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/apply_ally_wing", AllayWingJointModifier::new);
        SkinRendererManager2.registerModifier("armourers_workshop:modifier/apply_horse_body", HorseBodyJointModifier::new);
    }

    private static void registerPlugins() {
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/hidden_any_layer", DefaultLayerArmaturePlugin::any);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/hidden_villager_layer", DefaultLayerArmaturePlugin::villager);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/hidden_mob_layer", DefaultLayerArmaturePlugin::mob);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_villager_model", VillagerModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_trident_model", TridentModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_arrow_model", ArrowModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_fishing_model", FishingModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_boat_model", BoatModelArmaturePlugin::new);
        SkinRendererManager2.registerPlugin("armourers_workshop:plugin/fix_minecart_model", MinecartModelArmaturePlugin::new);
    }

    private static void registerRenderers() {
    }

    private static void registerModels() {
        SkinRendererManager2.registerModel("minecraft:model/slime", AbstractSkinnableModel.SLIME);
        SkinRendererManager2.registerModel("minecraft:model/ghast", AbstractSkinnableModel.GHAST);
        SkinRendererManager2.registerModel("minecraft:model/enderman", AbstractSkinnableModel.ENDERMAN);
        SkinRendererManager2.registerModel("minecraft:model/zombie_villager", AbstractSkinnableModel.ZOMBIE_VILLAGER);
        SkinRendererManager2.registerModel("minecraft:model/illager", AbstractSkinnableModel.ILLAGER, it -> {
            it.put("head", "root.head");
            it.put("body", "root.body");
            it.put("left_leg", "root.left_leg");
            it.put("right_leg", "root.right_leg");
            it.put("arms", "root.arms");
            it.put("right_arm", "root.right_arm");
            it.put("left_arm", "root.left_arm");
            it.put("hat", "root.head.hat");
            it.put("nose", "root.head.nose");
        });
        SkinRendererManager2.registerModel("minecraft:model/villager", AbstractSkinnableModel.VILLAGER, it -> {
            it.put("hat", "root.head.hat");
            it.put("hat_rim", "root.head.hat.hat_rim");
            it.put("head", "root.head");
            it.put("nose", "root.head.nose");
            it.put("body", "root.body");
            it.put("right_leg", "root.right_leg");
            it.put("left_leg", "root.left_leg");
            it.put("left_arm", "root.arms");
            it.put("right_arm", "root.arms");
            it.put("jacket", "root.body.jacket");
        });
        SkinRendererManager2.registerModel("minecraft:model/iron_golem", AbstractSkinnableModel.IRON_GOLEM, it -> {
            it.put("head", "root.head");
            it.put("body", "root.body");
            it.put("right_leg", "root.right_leg");
            it.put("left_leg", "root.left_leg");
            it.put("right_arm", "root.right_arm");
            it.put("left_arm", "root.left_arm");
        });
        SkinRendererManager2.registerModel("minecraft:model/humanoid", AbstractSkinnableModel.HUMANOID, it -> {
            it.put("head", "headParts[0]");
            it.put("body", "bodyParts[0]");
            it.put("right_arm", "bodyParts[1]");
            it.put("left_arm", "bodyParts[2]");
            it.put("right_leg", "bodyParts[3]");
            it.put("left_leg", "bodyParts[4]");
            it.put("hat", "bodyParts[5]");
        });
        SkinRendererManager2.registerModel("minecraft:model/player", AbstractSkinnableModel.PLAYER, it -> {
            it.put("left_pants", "bodyParts[6]");
            it.put("right_pants", "bodyParts[7]");
            it.put("left_sleeve", "bodyParts[8]");
            it.put("right_sleeve", "bodyParts[9]");
            it.put("jacket", "bodyParts[10]");
        });
        SkinRendererManager2.registerModel("minecraft:model/chicken", AbstractSkinnableModel.CHICKEN, it -> {
            it.put("head", "headParts[0]");
            it.put("beak", "headParts[1]");
            it.put("red_thing", "headParts[2]");
            it.put("body", "bodyParts[0]");
            it.put("right_leg", "bodyParts[1]");
            it.put("left_leg", "bodyParts[2]");
            it.put("right_wing", "bodyParts[3]");
            it.put("left_wing", "bodyParts[4]");
        });
        SkinRendererManager2.registerModel("minecraft:model/creeper", AbstractSkinnableModel.CREEPER, it -> it.put("head", "root.head"));
        SkinRendererManager2.registerModel("minecraft:model/horse", AbstractSkinnableModel.HORSE, it -> {
            it.put("head", "headParts[0]");
            it.put("body", "bodyParts[0]");
            it.put("right_hind_leg", "bodyParts[1]");
            it.put("left_hind_leg", "bodyParts[2]");
            it.put("right_front_leg", "bodyParts[3]");
            it.put("left_front_leg", "bodyParts[4]");
            it.put("right_front_baby_leg", "bodyParts[5]");
            it.put("left_front_baby_leg", "bodyParts[6]");
            it.put("right_hind_baby_leg", "bodyParts[7]");
            it.put("left_hind_baby_leg", "bodyParts[8]");
            it.put("tail", "bodyParts[0].tail");
        });
        SkinRendererManager2.registerModel("minecraft:model/pig", AbstractSkinnableModel.PIG);
        SkinRendererManager2.registerModel("minecraft:model/wolf", AbstractSkinnableModel.WOLF);
        SkinRendererManager2.registerModel("minecraft:model/guardian", AbstractSkinnableModel.GUARDIAN);
        SkinRendererManager2.registerModel("minecraft:model/phantom", AbstractSkinnableModel.PHANTOM);
        SkinRendererManager2.registerModel("minecraft:model/shulker", AbstractSkinnableModel.SHULKER);
        SkinRendererManager2.registerModel("minecraft:model/boat", AbstractSkinnableModel.BOAT, it -> {
            it.put("bottom", "parts[0]");
            it.put("back", "parts[1]");
            it.put("front", "parts[2]");
            it.put("right", "parts[3]");
            it.put("left", "parts[4]");
            it.put("left_paddle", "parts[5]");
            it.put("right_paddle", "parts[6]");
        });
        SkinRendererManager2.registerModel("minecraft:model/raft", AbstractSkinnableModel.RAFT, it -> {
            it.put("bottom", "parts[0]");
            it.put("left_paddle", "parts[1]");
            it.put("right_paddle", "parts[2]");
        });
        SkinRendererManager2.registerModel("minecraft:model/allay", AbstractSkinnableModel.ALLAY, it -> {
            it.put("root", "root");
            it.put("head", "root.head");
            it.put("body", "root.body");
            it.put("right_arm", "root.body.right_arm");
            it.put("left_arm", "root.body.left_arm");
            it.put("right_leg", "root.body.right_wing");
            it.put("left_leg", "root.body.left_wing");
            it.put("right_wing", "root.body.right_wing");
            it.put("left_wing", "root.body.left_wing");
        });
    }

    public static <T extends Model> void registerModel(String registryName, Class<T> clazz) {
        SkinRendererManager2.registerModel(registryName, clazz, it -> {});
    }

    public static <T extends Model> void registerModel(String registryName, Class<T> clazz, Consumer<Map<String, String>> provider) {
        if (clazz != null) {
            LinkedHashMap<String, String> mapper = new LinkedHashMap<String, String>();
            provider.accept(mapper);
            SkinRendererManager2.registerClass(registryName, clazz);
            AbstractModelHolder.register(clazz, mapper);
        }
    }

    public static class SimpleLoader
    implements IDataPackBuilder {
        private final IResourceLocation location;

        public SimpleLoader(IResourceLocation location) {
            this.location = location;
        }

        @Override
        public void append(IDataPackObject object, IResourceLocation file) {
            String type = object.get("type").stringValue();
            ArmatureTransformerManager manager = (ArmatureTransformerManager)MANAGERS.get((Object)type);
            if (manager != null) {
                manager.append(object, this.location);
            }
        }

        @Override
        public void build() {
        }

        public static void clean() {
            MANAGERS.values().forEach(ArmatureTransformerManager::clear);
        }

        public static void freeze() {
            MANAGERS.values().forEach(ArmatureTransformerManager::freeze);
        }
    }
}

