/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.modifier;

import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.core.armature.JointModifier;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class DefaultSkirtJointModifier
extends JointModifier {
    @Override
    public IJointTransform apply(IJoint joint, IModel model, IJointTransform transform) {
        IModelPart body = model.getPart("body");
        IModelPart leg1 = model.getPart("left_leg");
        IModelPart leg2 = model.getPart("right_leg");
        if (body == null || leg1 == null || leg2 == null) {
            return transform;
        }
        return poseStack -> {
            float xRot;
            float z = (leg1.pose().getZ() + leg2.pose().getZ()) / 2.0f;
            poseStack.translate(body.pose().getX(), leg1.pose().getY(), z);
            if (body.pose().getYRot() != 0.0f) {
                poseStack.rotate(Vector3f.YP.rotation(body.pose().getYRot()));
            }
            if (Float.compare(xRot = (this.ort(leg1.pose().getXRot()) + this.ort(leg2.pose().getXRot())) / 2.0f, 0.0f) != 0) {
                poseStack.rotate(Vector3f.XP.rotation(xRot));
            }
        };
    }

    private float ort(float q) {
        float pi = (float)Math.PI;
        if (q > pi) {
            return q - pi * 2.0f;
        }
        if (q < -pi) {
            return q + pi * 2.0f;
        }
        return q;
    }
}

