/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.IResourceManager;
import moe.plushie.armourers_workshop.api.math.ITexturePos;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.server.packs.resources.ResourceManager.Wrapper;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.color.TexturedPaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureModel;
import moe.plushie.armourers_workshop.core.texture.SkyBox;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BakedEntityTexture {
    private final HashMap<Integer, PaintColor> allColors = new HashMap();
    private final HashMap<ISkinPartType, HashMap<Integer, PaintColor>> allParts = new HashMap();
    private final HashMap<ISkinPartType, Rectangle3i> allBounds = new HashMap();
    private String model;
    private IResourceLocation resourceLocation;
    private boolean isSlimModel = false;
    private boolean isLoaded = false;

    public BakedEntityTexture() {
    }

    public BakedEntityTexture(IResourceLocation resourceLocation, boolean slim) {
        this.isSlimModel = slim;
        this.resourceLocation = resourceLocation;
        try {
            IResourceManager resourceManager = Wrapper.asResourceManager(Minecraft.m_91087_().m_91098_());
            BufferedImage bufferedImage = ImageIO.read(resourceManager.readResource(resourceLocation).getInputStream());
            if (bufferedImage != null) {
                this.loadColors(bufferedImage.getWidth(), bufferedImage.getHeight(), slim, bufferedImage::getRGB);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadImage(NativeImage image, boolean slim) {
        this.loadColors(image.m_84982_(), image.m_85084_(), slim, (x, y) -> {
            int color = image.m_84985_(x, y);
            int red = color << 16 & 0xFF0000;
            int blue = color >> 16 & 0xFF;
            return color & 0xFF00FF00 | red | blue;
        });
    }

    private void loadColors(int width, int height, boolean slim, IColorAccessor accessor) {
        for (Map.Entry entry : PlayerTextureModel.of(width, height, slim).entrySet()) {
            SkyBox box = (SkyBox)entry.getValue();
            HashMap part = this.allParts.computeIfAbsent((ISkinPartType)entry.getKey(), k -> new HashMap());
            this.allBounds.put((ISkinPartType)entry.getKey(), box.getBounds());
            box.forEach((texture, x, y, z, dir) -> {
                int color = accessor.getRGB(texture.getU(), texture.getV());
                if (PaintColor.isOpaque(color)) {
                    PaintColor paintColor = TexturedPaintColor.of(color, SkinPaintTypes.NORMAL);
                    part.put(this.getPosKey(x, y, z, dir), paintColor);
                    this.allColors.put(this.getUVKey(texture.getU(), texture.getV()), paintColor);
                }
            });
        }
        this.isLoaded = true;
    }

    public PaintColor getColor(ITexturePos texturePos) {
        return this.getColor(texturePos.getU(), texturePos.getV());
    }

    public PaintColor getColor(int u, int v) {
        return this.allColors.get(this.getUVKey(u, v));
    }

    public PaintColor getColor(int x, int y, int z, Direction dir, ISkinPartType partType) {
        HashMap<Integer, PaintColor> part = this.allParts.get(partType);
        Rectangle3i bounds = this.allBounds.get(partType);
        if (part == null || bounds == null) {
            return null;
        }
        x = MathUtils.clamp(x, bounds.getMinX(), bounds.getMaxX() - 1);
        y = MathUtils.clamp(y, bounds.getMinY(), bounds.getMaxY() - 1);
        z = MathUtils.clamp(z, bounds.getMinZ(), bounds.getMaxZ() - 1);
        return part.get(this.getPosKey(x, y, z, dir));
    }

    private int getPosKey(int x, int y, int z, Direction dir) {
        return (dir.m_122411_() & 0xFF) << 24 | (z & 0xFF) << 16 | (y & 0xFF) << 8 | x & 0xFF;
    }

    private int getUVKey(int u, int v) {
        return (v & 0xFFFF) << 16 | u & 0xFFFF;
    }

    public IResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(IResourceLocation location) {
        this.resourceLocation = location;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
        this.isSlimModel = Objects.equals(model, "slim");
    }

    public boolean isSlimModel() {
        return this.isSlimModel;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    static interface IColorAccessor {
        public int getRGB(int var1, int var2);
    }
}

