/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.texture.TextureManager;
import moe.plushie.armourers_workshop.core.texture.TextureAnimation;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureAnimationController {
    private static final OpenMatrix4f IDENTITY = OpenMatrix4f.identity();
    public static final TextureAnimationController NONE = new TextureAnimationController(0, 0, TextureAnimation.Mode.LOOP);
    public static final TextureAnimationController DEFAULT = new TextureAnimationController(25, 256, TextureAnimation.Mode.LOOP);
    private final int frameCount;
    private final float frameTime;
    private final OpenMatrix4f[] frames;

    public TextureAnimationController(TextureAnimation animation) {
        this(animation.getFrameTime(), animation.getFrameCount(), animation.getFrmaeMode());
    }

    public TextureAnimationController(int frameTime, int frameCount, TextureAnimation.Mode frameMode) {
        this.frames = this._genTextureMatrices(frameCount, frameMode);
        this.frameTime = (float)Math.max(frameTime, 1) / 1000.0f;
        this.frameCount = this.frames.length;
    }

    public static TextureAnimationController of(RenderType renderType) {
        if (renderType == SkinRenderType.FACE_SOLID || renderType == SkinRenderType.FACE_LIGHTING || renderType == SkinRenderType.FACE_TRANSLUCENT || renderType == SkinRenderType.FACE_LIGHTING_TRANSLUCENT) {
            return DEFAULT;
        }
        TextureManager.Entry storage = TextureManager.Entry.of(renderType);
        if (storage != null) {
            return storage.getAnimationController();
        }
        return NONE;
    }

    public OpenMatrix4f getTextureMatrix(float animationTicks) {
        if (this.frameCount != 0) {
            int idx = (int)(animationTicks / this.frameTime);
            return this.frames[idx % this.frameCount];
        }
        return IDENTITY;
    }

    private OpenMatrix4f[] _genTextureMatrices(int total, TextureAnimation.Mode mode) {
        if (total <= 0) {
            return new OpenMatrix4f[0];
        }
        if (mode.equals(TextureAnimation.Mode.LOOP)) {
            OpenMatrix4f[] frames = new OpenMatrix4f[total];
            for (int i = 0; i < total; ++i) {
                frames[i] = this._genTextureMatrix((float)i / (float)total);
            }
            return frames;
        }
        if (mode.equals(TextureAnimation.Mode.BACKWARDS)) {
            OpenMatrix4f[] frames = new OpenMatrix4f[total];
            for (int i = 0; i < total; ++i) {
                frames[total - i - 1] = this._genTextureMatrix((float)i / (float)total);
            }
            return frames;
        }
        if (mode.equals(TextureAnimation.Mode.BACK_AND_FORTH)) {
            int i;
            OpenMatrix4f[] frames = new OpenMatrix4f[total + total - 2];
            for (i = 0; i < total; ++i) {
                frames[i] = this._genTextureMatrix((float)i / (float)total);
            }
            for (i = 1; i < total; ++i) {
                frames[total - i - 1] = this._genTextureMatrix((float)i / (float)total);
            }
            return frames;
        }
        if (mode.getFrames() != null) {
            int[] indexes = mode.getFrames();
            OpenMatrix4f[] frames = new OpenMatrix4f[indexes.length];
            for (int i = 0; i < indexes.length; ++i) {
                frames[i] = this._genTextureMatrix((float)MathUtils.clamp(indexes[i], 0, total - 1) / (float)total);
            }
            return frames;
        }
        return new OpenMatrix4f[0];
    }

    private OpenMatrix4f _genTextureMatrix(float offset) {
        if (offset != 0.0f) {
            return OpenMatrix4f.createTranslateMatrix(0.0f, offset, 0.0f);
        }
        return IDENTITY;
    }
}

