/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.api.common.ITextureProperties;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.texture.TextureManager.UnregisteringAPI;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.texture.SmartResourceManager;
import moe.plushie.armourers_workshop.core.client.texture.TextureAnimationController;
import moe.plushie.armourers_workshop.core.data.cache.ReferenceCounted;
import moe.plushie.armourers_workshop.core.texture.TextureAnimation;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TextureManager {
    private static final AtomicInteger ID = new AtomicInteger(0);
    private static final TextureManager INSTANCE = new TextureManager();
    private final IdentityHashMap<ITextureProvider, Entry> textures = new IdentityHashMap();

    public static TextureManager getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
        ID.set(0);
    }

    public synchronized void stop() {
        this.textures.values().forEach(it -> it.bind(null));
        this.textures.clear();
    }

    public void open(RenderType renderType) {
        Entry entry = Entry.of(renderType);
        if (entry != null) {
            entry.retain();
        }
    }

    public void close(RenderType renderType) {
        Entry entry = Entry.of(renderType);
        if (entry != null) {
            entry.release();
        }
    }

    public synchronized RenderType register(ITextureProvider provider) {
        Entry entry = this.textures.get(provider);
        if (entry == null) {
            entry = new Entry(provider);
            this.textures.put(provider, entry);
        }
        return entry.getRenderType();
    }

    public static class Entry
    extends ReferenceCounted {
        private final IResourceLocation location;
        private final RenderType renderType;
        private final Map<IResourceLocation, ByteBuffer> textureBuffers;
        private final TextureAnimationController animationController;

        public Entry(ITextureProvider provider) {
            this.location = this.resolveResourceLocation(provider);
            this.renderType = this.resolveRenderType(this.location, provider);
            this.textureBuffers = this.resolveTextureBuffers(this.location, provider);
            this.animationController = new TextureAnimationController((TextureAnimation)provider.getAnimation());
            this.bind(this);
        }

        @Nullable
        public static Entry of(RenderType renderType) {
            return (Entry)IAssociatedObjectProvider.get(renderType);
        }

        @Override
        protected void init() {
            RenderSystem.recordRenderCall(() -> {
                this.textureBuffers.forEach(SmartResourceManager.getInstance()::register);
                Minecraft.m_91087_().m_91097_().m_118495_(this.location.toLocation(), (AbstractTexture)new SimpleTexture(this.location.toLocation()));
            });
        }

        @Override
        protected void dispose() {
            RenderSystem.recordRenderCall(() -> {
                this.textureBuffers.keySet().forEach(SmartResourceManager.getInstance()::unregister);
                UnregisteringAPI.unregister(Minecraft.m_91087_().m_91097_(), this.location.toLocation());
            });
        }

        public IResourceLocation getLocation() {
            return this.location;
        }

        public RenderType getRenderType() {
            return this.renderType;
        }

        public TextureAnimationController getAnimationController() {
            return this.animationController;
        }

        public String toString() {
            return this.location.toString();
        }

        protected void bind(Entry newValue) {
            IAssociatedObjectProvider provider = (IAssociatedObjectProvider)ObjectUtils.unsafeCast(this.renderType);
            provider.setAssociatedObject(newValue);
        }

        private IResourceLocation resolveResourceLocation(ITextureProvider provider) {
            String path = "textures/dynamic/" + ID.getAndIncrement();
            return ModConstants.key(path + ".png");
        }

        private RenderType resolveRenderType(IResourceLocation location, ITextureProvider provider) {
            ITextureProperties properties = provider.getProperties();
            if (properties.isEmissive()) {
                return SkinRenderType.customLightingFace(location);
            }
            return SkinRenderType.customSolidFace(location);
        }

        private Map<IResourceLocation, ByteBuffer> resolveTextureBuffers(IResourceLocation location, ITextureProvider provider) {
            String path = SkinFileUtils.removeExtension(location.getPath());
            LinkedHashMap<IResourceLocation, ByteBuffer> results = new LinkedHashMap<IResourceLocation, ByteBuffer>();
            results.put(location, provider.getBuffer());
            for (ITextureProvider variant : provider.getVariants()) {
                if (variant.getProperties().isNormal()) {
                    results.put(ModConstants.key(path + "_n.png"), variant.getBuffer());
                }
                if (!variant.getProperties().isSpecular()) continue;
                results.put(ModConstants.key(path + "_s.png"), variant.getBuffer());
            }
            return results;
        }
    }
}

