/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.crafting.recipe;

import moe.plushie.armourers_workshop.api.common.IDataComponentType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public abstract class SkinningRecipe {
    protected ISkinType skinType;

    public SkinningRecipe(ISkinType skinType) {
        this.skinType = skinType;
    }

    public void apply(Container inventory) {
        ItemStack skinStack = ItemStack.f_41583_;
        ItemStack targetStack = ItemStack.f_41583_;
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (this.isValidSkin(itemStack)) {
                skinStack = itemStack;
                continue;
            }
            if (this.isValidTarget(itemStack)) {
                targetStack = itemStack;
                continue;
            }
            return;
        }
        if (targetStack.m_41619_() || skinStack.m_41619_()) {
            return;
        }
        this.shrink(targetStack, skinStack);
    }

    public ItemStack test(Container inventory) {
        ItemStack skinStack = ItemStack.f_41583_;
        ItemStack targetStack = ItemStack.f_41583_;
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (this.isValidSkin(itemStack)) {
                skinStack = itemStack;
                continue;
            }
            if (this.isValidTarget(itemStack)) {
                targetStack = itemStack;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (targetStack.m_41619_() || skinStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return this.build(targetStack, skinStack);
    }

    protected void shrink(ItemStack targetStack, ItemStack skinStack) {
        targetStack.m_41774_(1);
        skinStack.m_41774_(1);
    }

    protected ItemStack build(ItemStack targetStack, ItemStack skinStack) {
        ItemStack newItemStack = targetStack.m_41777_();
        newItemStack.m_41764_(1);
        ComponentAPI.set(newItemStack, (IDataComponentType)ModDataComponents.SKIN.get(), ComponentAPI.get(skinStack, (IDataComponentType)ModDataComponents.SKIN.get()));
        return newItemStack;
    }

    protected boolean isValidSkin(ItemStack itemStack) {
        return ModItems.SKIN.get() == itemStack.m_41720_() && SkinDescriptor.of(itemStack).getType() == this.skinType;
    }

    protected boolean isValidTarget(ItemStack itemStack) {
        return ModItems.SKIN.get() != itemStack.m_41720_();
    }
}

