/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

public enum DataDomain {
    LOCAL("fs"),
    DEDICATED_SERVER("ws"),
    DATABASE("db"),
    DATABASE_LINK("ln"),
    GLOBAL_SERVER("ks"),
    GLOBAL_SERVER_PREVIEW("kv"),
    SLICE_LOAD("sp");

    private final String namespace;

    private DataDomain(String namespace) {
        this.namespace = namespace;
    }

    public static DataDomain byName(String path) {
        String namespace = DataDomain.getNamespace(path);
        for (DataDomain domain : DataDomain.values()) {
            if (!domain.namespace.equals(namespace)) continue;
            return domain;
        }
        return LOCAL;
    }

    public static String getNamespace(String path) {
        int index = path.indexOf(":");
        if (index < 0) {
            return "";
        }
        return path.substring(0, index);
    }

    public static String getPath(String path) {
        int index = path.indexOf(":");
        if (index < 0) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static boolean isLocal(String path) {
        return LOCAL.matches(path);
    }

    public static boolean isServer(String path) {
        return DEDICATED_SERVER.matches(path);
    }

    public static boolean isDatabase(String path) {
        return DATABASE.matches(path) || DATABASE_LINK.matches(path);
    }

    public static boolean isVolatile(String path) {
        return DataDomain.isLocal(path) || DataDomain.isServer(path);
    }

    public boolean matches(String s) {
        return s.startsWith(this.namespace + ":");
    }

    public String normalize(String s) {
        return this.namespace + ":" + s;
    }

    public String namespace() {
        return this.namespace;
    }
}

