/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import moe.plushie.armourers_workshop.core.data.source.SkinFileDataSource;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;

public class DataManager {
    private static final DataManager INSTANCE = new DataManager();
    private SkinFileDataSource fileDataSource;
    private final HashMap<String, Connection> reusableConnections = new HashMap();

    public static DataManager getInstance() {
        return INSTANCE;
    }

    public void connect(File rootPath) {
        try {
            this.reusableConnections.clear();
            this.fileDataSource = this.createFileDataSource(new SkinFileDataSource.Local(rootPath));
            if (this.fileDataSource != null) {
                this.fileDataSource.connect();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void disconnect() {
        try {
            this.reusableConnections.clear();
            if (this.fileDataSource != null) {
                this.fileDataSource.disconnect();
                this.fileDataSource = null;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String saveSkin(Skin skin) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(5120);
        SkinFileStreamUtils.saveSkinToStream(stream, skin);
        byte[] bytes = stream.toByteArray();
        return this.saveSkinData(new ByteArrayInputStream(bytes));
    }

    public Skin loadSkin(String id) throws Exception {
        InputStream inputStream = this.loadSkinData(id);
        return SkinFileStreamUtils.loadSkinFromStream2(inputStream);
    }

    public String saveSkinData(InputStream inputStream) throws Exception {
        if (this.fileDataSource != null) {
            return this.fileDataSource.save(inputStream);
        }
        throw new Exception("Missing data source connect!");
    }

    public InputStream loadSkinData(String id) throws Exception {
        if (this.fileDataSource != null) {
            return this.fileDataSource.load(id);
        }
        throw new Exception("Missing data source connect!");
    }

    public boolean isConnected() {
        return this.fileDataSource != null;
    }

    private SkinFileDataSource createFileDataSource(SkinFileDataSource fallback) throws Exception {
        String uri = ModConfig.Common.skinDatabaseURL;
        if (uri.startsWith("jdbc:")) {
            String name = uri.replaceAll("jdbc:([^:]+):(.+)", "$1");
            SkinFileDataSource.SQL source = new SkinFileDataSource.SQL(name, this.createConnection(uri));
            return new SkinFileDataSource.Fallback(source, fallback);
        }
        return fallback;
    }

    private Connection createConnection(String uri) throws Exception {
        Connection connection = this.reusableConnections.get(uri);
        if (connection != null) {
            return connection;
        }
        connection = DriverManager.getConnection(uri);
        this.reusableConnections.put(uri, connection);
        return connection;
    }
}

