/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.IResourceManager;
import moe.plushie.armourers_workshop.api.data.IDataPackBuilder;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.server.packs.resources.ResourceManager.Wrapper;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import moe.plushie.armourers_workshop.utils.ext.OpenResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class DataPackLoader
implements PreparableReloadListener {
    protected final ArrayList<Entry> entries = new ArrayList();

    public void add(Entry entry) {
        this.entries.add(entry);
        this.entries.sort(Comparator.comparingInt(it -> it.order));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier barrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller2, Executor executor, Executor executor2) {
        ArrayList allJobs = new ArrayList();
        ArrayList allCompletes = new ArrayList();
        this.build((supplier, consumer) -> {
            CompletableFuture job = CompletableFuture.supplyAsync(supplier, executor);
            allJobs.add(job);
            allCompletes.add(() -> consumer.accept((Map)job.join()));
        }, resourceManager);
        return ((CompletableFuture)CompletableFuture.allOf(allJobs.toArray(new CompletableFuture[0])).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0))).thenAcceptAsync(it -> allCompletes.forEach(Runnable::run), executor2);
    }

    public void build(TaskQueue taskQueue, ResourceManager resourceManager) {
        IResourceManager resourceManager1 = Wrapper.asResourceManager(resourceManager);
        this.entries.forEach(entry -> taskQueue.accept(entry.prepare(resourceManager1), entry::load));
    }

    public static interface TaskQueue {
        public void accept(Supplier<Map<IResourceLocation, IDataPackBuilder>> var1, Consumer<Map<IResourceLocation, IDataPackBuilder>> var2);
    }

    public static class Entry {
        private final IResourceLocation target;
        private final Function<IResourceLocation, IDataPackBuilder> provider;
        private final Runnable willLoadHandler;
        private final Runnable didLoadHandler;
        private final int order;

        public Entry(String path, Function<IResourceLocation, IDataPackBuilder> provider, Runnable willLoadHandler, Runnable didLoadHandler, int order) {
            this.target = ModConstants.key(path);
            this.provider = provider;
            this.willLoadHandler = willLoadHandler;
            this.didLoadHandler = didLoadHandler;
            this.order = order;
        }

        public Supplier<Map<IResourceLocation, IDataPackBuilder>> prepare(IResourceManager resourceManager) {
            if (this.willLoadHandler != null) {
                this.willLoadHandler.run();
            }
            return () -> {
                HashMap results = new HashMap();
                resourceManager.readResources(this.target, s -> s.endsWith(".json"), (location, resource) -> {
                    IDataPackObject object = StreamUtils.fromPackObject(resource);
                    if (object == null) {
                        return;
                    }
                    String path = SkinFileUtils.removeExtension(location.getPath());
                    OpenResourceLocation location1 = OpenResourceLocation.create(location.getNamespace(), path);
                    ModLog.debug("Load entry '{}' in '{}'", location1, resource.getSource());
                    results.computeIfAbsent(location1, this.provider).append(object, (IResourceLocation)location);
                });
                return results;
            };
        }

        public void load(Map<IResourceLocation, IDataPackBuilder> results) {
            results.forEach((key, builder) -> builder.build());
            if (this.didLoadHandler != null) {
                this.didLoadHandler.run();
            }
        }
    }
}

