/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import joptsimple.internal.Strings;
import moe.plushie.armourers_workshop.core.data.EntityAction;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import moe.plushie.armourers_workshop.core.data.transform.SkinWingsTransform;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.Nullable;

public class EntityActionSet {
    private final BitSet flags = new BitSet(EntityAction.values().length);
    private Entity transitingVehicle = null;
    private TransitingMode transitingMode = null;

    @Nullable
    public static EntityActionSet of(@Nullable Entity entity) {
        if (entity != null) {
            return EntityDataStorage.of(entity).getActionSet().orElse(null);
        }
        return null;
    }

    public void startRiding(Entity target) {
        this.transitingVehicle = target;
        this.transitingMode = TransitingMode.UP;
    }

    public void stopRiding(Entity target) {
        this.transitingVehicle = target;
        this.transitingMode = TransitingMode.DOWN;
    }

    public void tick(Entity entity) {
        LivingEntity livingEntity;
        this.flags.clear();
        if (entity.m_5833_()) {
            return;
        }
        Entity vehicle = entity.m_20202_();
        if (vehicle == null) {
            vehicle = this.transitingVehicle;
        }
        boolean onGround = entity.m_20096_();
        double dx = entity.m_20185_() - entity.f_19790_;
        double dy = entity.m_20186_() - entity.f_19791_;
        double dz = entity.m_20189_() - entity.f_19792_;
        boolean isWalk = dx * dx + dz * dz > 2.5E-7;
        boolean isWalkUp = dy > 1.0E-7;
        boolean isWalkDown = dy < -1.0E-7;
        boolean isSprinting = entity.m_20142_();
        boolean isCrouching = entity.m_6047_();
        if (vehicle != null) {
            this.set(EntityAction.RIDING, true);
            this.set(EntityAction.RIDING_WALK, isWalk);
            this.set(EntityAction.RIDING_BOOST, isWalk && isSprinting);
            this.set(EntityAction.RIDING_UP, this.transitingMode == TransitingMode.UP);
            this.set(EntityAction.RIDING_DOWN, this.transitingMode == TransitingMode.DOWN);
            this.set(EntityAction.RIDING_BOAT, this.isBoat(vehicle));
            this.set(EntityAction.RIDING_PIG, this.isPig(vehicle));
            this.set(EntityAction.RIDING_HORSE, this.isHorse(vehicle));
            if (this.transitingMode != null && entity.m_20089_() != Pose.CROUCHING) {
                this.transitingVehicle = null;
                this.transitingMode = null;
            }
            return;
        }
        if (entity instanceof LivingEntity && this.isFlying(livingEntity = (LivingEntity)entity)) {
            this.set(EntityAction.FLYING, true);
            this.set(EntityAction.FLYING_WALK, isWalk);
            this.set(EntityAction.FLYING_BOOST, isWalk && isSprinting);
            this.set(EntityAction.FLYING_UP, isWalkUp);
            this.set(EntityAction.FLYING_DOWN, isWalkDown);
            this.set(EntityAction.FLYING_FALL, livingEntity.m_21255_());
            return;
        }
        if (entity.m_20069_()) {
            this.set(EntityAction.SWIMMING, true);
            this.set(EntityAction.SWIMMING_WALK, isWalk);
            this.set(EntityAction.SWIMMING_BOOST, entity.m_6069_());
            this.set(EntityAction.SWIMMING_UP, isWalkUp);
            this.set(EntityAction.SWIMMING_DOWN, isWalkDown && !onGround);
            return;
        }
        if (entity.m_20089_() == Pose.SWIMMING) {
            this.set(EntityAction.CRAWLING, true);
            this.set(EntityAction.CRAWLING_WALK, isWalk);
            return;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6147_()) {
            this.set(EntityAction.CLIMBING, true);
            this.set(EntityAction.CLIMBING_WALK, isWalk);
            this.set(EntityAction.CLIMBING_UP, isWalkUp && !onGround);
            this.set(EntityAction.CLIMBING_DOWN, isWalkDown && !onGround && !isCrouching);
            this.set(EntityAction.CLIMBING_HOLD, isCrouching && !onGround && !isWalkUp);
            return;
        }
        this.set(EntityAction.WALK, isWalk);
        this.set(EntityAction.RUNNING, isSprinting);
        this.set(EntityAction.SNEAK, isCrouching);
        this.set(EntityAction.JUMP, !onGround);
    }

    public void set(EntityAction action, boolean value) {
        if (value) {
            this.flags.set(action.ordinal());
        }
    }

    public boolean contains(EntityAction action) {
        if (action == EntityAction.IDLE) {
            return this.flags.isEmpty();
        }
        return this.flags.get(action.ordinal());
    }

    private boolean isFlying(LivingEntity entity) {
        return SkinWingsTransform.isFlying(entity);
    }

    private boolean isBoat(Entity entity) {
        return entity instanceof Boat;
    }

    private boolean isPig(Entity entity) {
        return entity instanceof Pig;
    }

    private boolean isHorse(Entity entity) {
        return entity instanceof AbstractHorse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityActionSet)) {
            return false;
        }
        EntityActionSet that = (EntityActionSet)o;
        return this.flags.equals(that.flags);
    }

    public int hashCode() {
        return this.flags.hashCode();
    }

    public EntityActionSet copy() {
        EntityActionSet result = new EntityActionSet();
        result.flags.or(this.flags);
        return result;
    }

    public String toString() {
        String prefix = "";
        LinkedHashMap<String, ArrayList> lists = new LinkedHashMap<String, ArrayList>();
        StringBuilder results = new StringBuilder();
        for (EntityAction flag : EntityAction.values()) {
            if (!this.contains(flag)) continue;
            String[] parts = flag.name().toLowerCase().split("_");
            ArrayList sp = lists.computeIfAbsent(parts[0], k -> new ArrayList());
            sp.addAll(Arrays.asList(parts).subList(1, parts.length));
        }
        for (Map.Entry entry : lists.entrySet()) {
            results.append(prefix);
            results.append((String)entry.getKey());
            prefix = "; ";
            if (((ArrayList)entry.getValue()).isEmpty()) continue;
            results.append("[");
            results.append(Strings.join((Iterable)((Iterable)entry.getValue()), (String)","));
            results.append("]");
        }
        return results.toString();
    }

    public static enum TransitingMode {
        UP,
        DOWN;

    }
}

