/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.data.EntityAction;
import moe.plushie.armourers_workshop.core.data.EntityActionTarget;

public class EntityActions {
    private static final Map<String, EntityActionTarget> NAMED_ACTIONS = new HashMap<String, EntityActionTarget>();

    public static void init() {
        EntityActions.register(100.0f, "idle", EntityAction.IDLE);
        EntityActions.register(220.0f, "walk", EntityAction.WALK);
        EntityActions.register(240.0f, "run", EntityAction.WALK, EntityAction.RUNNING);
        EntityActions.register(280.0f, "jump", EntityAction.JUMP);
        EntityActions.register(200.0f, "sneak", EntityAction.SNEAK);
        EntityActions.register(220.0f, "sneak_idle", EntityAction.SNEAK);
        EntityActions.register(240.0f, "sneak_walk", EntityAction.SNEAK, EntityAction.WALK);
        EntityActions.register(300.0f, "swim", EntityAction.SWIMMING);
        EntityActions.register(320.0f, "swim_idle", EntityAction.SWIMMING);
        EntityActions.register(340.0f, "swim_walk", EntityAction.SWIMMING, EntityAction.SWIMMING_WALK);
        EntityActions.register(380.0f, "swim_sprint", EntityAction.SWIMMING, EntityAction.SWIMMING_BOOST);
        EntityActions.register(400.0f, "fly", EntityAction.FLYING);
        EntityActions.register(420.0f, "fly_idle", EntityAction.FLYING);
        EntityActions.register(440.0f, "fly_walk", EntityAction.FLYING, EntityAction.FLYING_WALK);
        EntityActions.register(480.0f, "fly_sprint", EntityAction.FLYING, EntityAction.FLYING_BOOST);
        EntityActions.register(401.0f, "fall_fly", EntityAction.FLYING, EntityAction.FLYING_FALL);
        EntityActions.register(421.0f, "fall_fly_idle", EntityAction.FLYING, EntityAction.FLYING_FALL);
        EntityActions.register(441.0f, "fall_fly_walk", EntityAction.FLYING, EntityAction.FLYING_FALL, EntityAction.FLYING_WALK);
        EntityActions.register(481.0f, "fall_fly_sprint", EntityAction.FLYING, EntityAction.FLYING_FALL, EntityAction.FLYING_BOOST);
        EntityActions.register(500.0f, "ride", EntityAction.RIDING);
        EntityActions.register(520.0f, "ride_idle", EntityAction.RIDING);
        EntityActions.register(540.0f, "ride_walk", EntityAction.RIDING, EntityAction.RIDING_WALK);
        EntityActions.register(580.0f, "ride_sprint", EntityAction.RIDING, EntityAction.FLYING_BOOST);
        EntityActions.register(501.0f, "boat", EntityAction.RIDING, EntityAction.RIDING_BOAT);
        EntityActions.register(521.0f, "boat_idle", EntityAction.RIDING, EntityAction.RIDING_BOAT);
        EntityActions.register(541.0f, "boat_walk", EntityAction.RIDING, EntityAction.RIDING_BOAT, EntityAction.RIDING_WALK);
        EntityActions.register(581.0f, "boat_sprint", EntityAction.RIDING, EntityAction.RIDING_BOAT, EntityAction.FLYING_BOOST);
        EntityActions.register(800.0f, "crawl", EntityAction.CRAWLING);
        EntityActions.register(820.0f, "crawl_idle", EntityAction.CRAWLING);
        EntityActions.register(840.0f, "crawl_walk", EntityAction.CRAWLING, EntityAction.CRAWLING_WALK);
        EntityActions.register(800.0f, "climb", EntityAction.CLIMBING);
        EntityActions.register(820.0f, "climb_idle", EntityAction.CLIMBING);
        EntityActions.register(847.0f, "climb_walk", EntityAction.CLIMBING, EntityAction.CLIMBING_WALK);
        EntityActions.register(848.0f, "climb_walk_up", EntityAction.CLIMBING, EntityAction.CLIMBING_UP);
        EntityActions.register(849.0f, "climb_walk_down", EntityAction.CLIMBING, EntityAction.CLIMBING_DOWN);
        EntityActions.register(880.0f, "climb_hold", EntityAction.CLIMBING, EntityAction.CLIMBING_HOLD);
    }

    public static EntityActionTarget by(String name) {
        EntityActionTarget target = NAMED_ACTIONS.get(name);
        if (target != null) {
            return target;
        }
        return new EntityActionTarget(name, 0.0f, Lists.newArrayList(), 0);
    }

    private static void register(float priority, String name, EntityAction ... actions) {
        NAMED_ACTIONS.put(name, new EntityActionTarget(name, priority, Lists.newArrayList((Object[])actions), -1));
    }
}

