/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.Optional;
import moe.plushie.armourers_workshop.api.common.ICapabilityType;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeJS;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.data.EntityActionSet;
import moe.plushie.armourers_workshop.init.ModCapabilities;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.utils.LazyOptional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityDataStorage {
    public static EntityImpl of(Entity entity) {
        return IAssociatedObjectProvider.of(entity, EntityImpl::new);
    }

    public static BlockEntityImpl of(BlockEntity entity) {
        return IAssociatedObjectProvider.of(entity, BlockEntityImpl::new);
    }

    public static class EntityImpl {
        protected final LazyOptional<SkinWardrobe> wardrobe;
        protected final LazyOptional<SkinWardrobeJS> wardrobeJS;
        protected final LazyOptional<EntityRenderData> renderData;
        protected final LazyOptional<EntityActionSet> actionSet;

        public EntityImpl(Entity entity) {
            this.wardrobe = EntityImpl.getLazyWardrobe(entity);
            this.wardrobeJS = EntityImpl.getLazyWardrobeJS(this.wardrobe);
            this.renderData = EntityImpl.getLazyRenderData(entity);
            this.actionSet = EntityImpl.getLazyActionSet(entity);
        }

        public Optional<SkinWardrobe> getWardrobe() {
            return this.wardrobe.resolve();
        }

        public Optional<SkinWardrobeJS> getWardrobeJS() {
            return this.wardrobeJS.resolve();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Optional<EntityRenderData> getRenderData() {
            return this.renderData.resolve();
        }

        public Optional<EntityActionSet> getActionSet() {
            return this.actionSet.resolve();
        }

        private static LazyOptional<SkinWardrobe> getLazyWardrobe(Entity entity) {
            Optional wardrobe = ((ICapabilityType)ModCapabilities.WARDROBE.get()).get(entity);
            if (wardrobe.isPresent()) {
                return LazyOptional.of(wardrobe::get);
            }
            return LazyOptional.empty();
        }

        private static LazyOptional<SkinWardrobeJS> getLazyWardrobeJS(LazyOptional<SkinWardrobe> provider) {
            return LazyOptional.of(() -> new SkinWardrobeJS(provider.resolve().orElse(null)));
        }

        private static LazyOptional<EntityRenderData> getLazyRenderData(Entity entity) {
            Optional renderData = EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> new EntityRenderData(entity));
            if (renderData.isPresent()) {
                return LazyOptional.of(renderData::get);
            }
            return LazyOptional.empty();
        }

        private static LazyOptional<EntityActionSet> getLazyActionSet(Entity entity) {
            return LazyOptional.of(EntityActionSet::new);
        }
    }

    public static class BlockEntityImpl {
        protected final LazyOptional<BlockEntityRenderData> renderData;

        public BlockEntityImpl(BlockEntity entity) {
            this.renderData = BlockEntityImpl.getLazyRenderData(entity);
        }

        @OnlyIn(value=Dist.CLIENT)
        public Optional<BlockEntityRenderData> getRenderData() {
            return this.renderData.resolve();
        }

        private static LazyOptional<BlockEntityRenderData> getLazyRenderData(BlockEntity blockEntity) {
            Optional renderData = EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> new BlockEntityRenderData(blockEntity));
            if (renderData.isPresent()) {
                return LazyOptional.of(renderData::get);
            }
            return LazyOptional.empty();
        }
    }
}

