/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class LocalDataReference {
    protected final String id;
    protected final ISkinType type;
    protected final CollisionBoxInfo collision;
    protected final List<AnimationInfo> animations;
    protected final SkinProperties properties;
    protected final int propertiesHash;

    public LocalDataReference(String id, Skin skin) {
        this.id = id;
        this.type = skin.getType();
        this.collision = CollisionBoxInfo.from(skin);
        this.animations = AnimationInfo.from(skin);
        this.properties = skin.getProperties();
        this.propertiesHash = this.properties.hashCode();
    }

    public LocalDataReference(CompoundTag tag) {
        this.id = tag.m_128461_("UUID");
        this.type = SkinTypes.byName(tag.m_128461_("Type"));
        this.collision = CollisionBoxInfo.from(tag);
        this.animations = AnimationInfo.from(tag);
        this.properties = new SkinProperties();
        this.properties.readFromNBT(tag.m_128469_("Properties"));
        this.propertiesHash = tag.m_128451_("PropertiesHash");
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("UUID", this.id);
        tag.m_128359_("Type", this.type.getRegistryName().toString());
        CollisionBoxInfo.write(this.collision, tag);
        AnimationInfo.write(this.animations, tag);
        CompoundTag props = new CompoundTag();
        this.properties.writeToNBT(props);
        tag.m_128365_("Properties", (Tag)props);
        tag.m_128405_("PropertiesHash", this.propertiesHash);
        return tag;
    }

    public static class CollisionBoxInfo {
        private final List<Rectangle3i> boxes;

        public CollisionBoxInfo(List<Rectangle3i> boxes) {
            this.boxes = boxes;
        }

        public CollisionBoxInfo(CompoundTag tag) {
            this.boxes = new ArrayList<Rectangle3i>();
            for (Tag boxTag : tag.m_128437_("Rect", 11)) {
                IntArrayTag arrayTag;
                if (!(boxTag instanceof IntArrayTag) || (arrayTag = (IntArrayTag)boxTag).size() < 6) continue;
                int[] array = arrayTag.m_128648_();
                this.boxes.add(new Rectangle3i(array[0], array[1], array[2], array[3], array[4], array[5]));
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            ListTag listTag = new ListTag();
            for (Rectangle3i box : this.boxes) {
                int[] array = new int[]{box.getX(), box.getY(), box.getZ(), box.getWidth(), box.getHeight(), box.getDepth()};
                listTag.add((Object)new IntArrayTag(array));
            }
            tag.m_128365_("Rect", (Tag)listTag);
            return tag;
        }

        public static CollisionBoxInfo from(Skin skin) {
            SkinSettings settings = skin.getSettings();
            if (settings != null && settings.getCollisionBox() != null && !settings.getCollisionBox().isEmpty()) {
                return new CollisionBoxInfo(settings.getCollisionBox());
            }
            return null;
        }

        public static CollisionBoxInfo from(CompoundTag tag) {
            if (tag.m_128441_("Collisions")) {
                return new CollisionBoxInfo(tag.m_128469_("Collisions"));
            }
            return null;
        }

        public static void write(CollisionBoxInfo size, CompoundTag tag) {
            if (size != null) {
                tag.m_128365_("Collisions", (Tag)size.serializeNBT());
            }
        }
    }

    public static class AnimationInfo {
        private final String name;
        private final float duration;
        private final int loop;

        public AnimationInfo(SkinAnimation animation) {
            this.name = animation.getName();
            this.duration = animation.getDuration();
            this.loop = switch (animation.getLoop()) {
                default -> throw new IncompatibleClassChangeError();
                case SkinAnimationLoop.LOOP -> -1;
                case SkinAnimationLoop.LAST_FRAME -> 0;
                case SkinAnimationLoop.NONE -> 1;
            };
        }

        public AnimationInfo(CompoundTag tag) {
            this.name = tag.m_128461_("Name");
            this.duration = tag.m_128457_("Duration");
            this.loop = tag.m_128451_("Loop");
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Name", this.name);
            tag.m_128350_("Duration", this.duration);
            tag.m_128405_("Loop", this.loop);
            return tag;
        }

        public static List<AnimationInfo> from(Skin skin) {
            ArrayList<AnimationInfo> infos = new ArrayList<AnimationInfo>();
            for (SkinAnimation animation : skin.getAnimations()) {
                infos.add(new AnimationInfo(animation));
            }
            return infos;
        }

        public static List<AnimationInfo> from(CompoundTag tag) {
            if (tag.m_128441_("Animations")) {
                ListTag lists = tag.m_128437_("Animations", 10);
                ArrayList<AnimationInfo> animations = new ArrayList<AnimationInfo>();
                for (Tag animationTag : lists) {
                    if (!(animationTag instanceof CompoundTag)) continue;
                    CompoundTag tag1 = (CompoundTag)animationTag;
                    animations.add(new AnimationInfo(tag1));
                }
                return animations;
            }
            return null;
        }

        public static void write(List<AnimationInfo> animations, CompoundTag tag) {
            if (animations != null && !animations.isEmpty()) {
                ListTag listTag = new ListTag();
                for (AnimationInfo animation : animations) {
                    listTag.add((Object)animation.serializeNBT());
                }
                tag.m_128365_("Animations", (Tag)listTag);
            }
        }
    }
}

