/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.color;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinDye;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class ColorScheme
implements ISkinDye {
    public static final ColorScheme EMPTY = new ColorScheme();
    private final HashMap<ISkinPaintType, IPaintColor> colors = new HashMap();
    private HashMap<ISkinPaintType, IPaintColor> resolvedColors;
    private ColorScheme reference;
    private IResourceLocation texture;
    private int hashCode;

    public ColorScheme() {
    }

    public ColorScheme(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            SkinPaintType paintType = SkinPaintTypes.byName(key);
            if (paintType == SkinPaintTypes.NONE || !nbt.m_128425_(key, 3)) continue;
            this.colors.put(paintType, PaintColor.of(nbt.m_128451_(key)));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.colors.forEach((paintType, paintColor) -> nbt.m_128405_(paintType.getRegistryName().toString(), paintColor.getRawValue()));
        return nbt;
    }

    public ColorScheme copy() {
        ColorScheme scheme = new ColorScheme();
        scheme.colors.putAll(this.colors);
        scheme.reference = this.reference;
        scheme.texture = this.texture;
        return scheme;
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        if (this.reference != null && !this.reference.isEmpty()) {
            return false;
        }
        if (this.texture != null) {
            return false;
        }
        return this.colors.isEmpty();
    }

    @Nullable
    public IPaintColor getColor(ISkinPaintType paintType) {
        IPaintColor color = this.colors.get(paintType);
        if (color != null) {
            return color;
        }
        if (this.reference != null) {
            return this.reference.getColor(paintType);
        }
        return null;
    }

    public void setColor(ISkinPaintType paintType, IPaintColor color) {
        this.colors.put(paintType, color);
        this.resolvedColors = null;
        this.hashCode = 0;
    }

    public IPaintColor getResolvedColor(ISkinPaintType paintType) {
        if (this.resolvedColors == null) {
            this.resolvedColors = this.getResolvedColors();
        }
        return this.resolvedColors.get(paintType);
    }

    public IResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(IResourceLocation texture) {
        this.texture = texture;
    }

    public ColorScheme getReference() {
        if (this.reference != null) {
            return this.reference;
        }
        return EMPTY;
    }

    public void setReference(ColorScheme reference) {
        if (reference != null && reference.isEmpty()) {
            reference = null;
        }
        if (!Objects.equals(this.reference, reference)) {
            this.reference = reference;
            this.resolvedColors = null;
            this.hashCode = 0;
        }
    }

    private HashMap<ISkinPaintType, IPaintColor> getResolvedColors() {
        HashMap<ISkinPaintType, IPaintColor> resolvedColors = new HashMap<ISkinPaintType, IPaintColor>();
        HashMap<ISkinPaintType, ArrayList> dependencies = new HashMap<ISkinPaintType, ArrayList>();
        if (this.reference != null) {
            resolvedColors.putAll(this.reference.getResolvedColors());
        }
        Iterables.concat(this.colors.entrySet(), this.getReference().colors.entrySet()).forEach(e -> {
            ISkinPaintType paintType = (ISkinPaintType)e.getKey();
            IPaintColor color = (IPaintColor)e.getValue();
            if (color.getPaintType().getDyeType() != null) {
                dependencies.computeIfAbsent(color.getPaintType(), k -> new ArrayList()).add(paintType);
            } else {
                resolvedColors.put(paintType, color);
            }
        });
        if (resolvedColors.isEmpty()) {
            return resolvedColors;
        }
        dependencies.forEach((key, value) -> Iterables.tryFind(dependencies.values(), v -> v.contains(key)).toJavaUtil().ifPresent(target -> {
            if (target != value) {
                target.addAll(value);
            }
            value.clear();
        }));
        dependencies.forEach((key, value) -> value.forEach(paintType -> resolvedColors.put((ISkinPaintType)paintType, (IPaintColor)resolvedColors.get(key))));
        return resolvedColors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColorScheme)) {
            return false;
        }
        ColorScheme that = (ColorScheme)o;
        return this.colors.equals(that.colors) && Objects.equals(this.texture, that.texture) && Objects.equals(this.reference, that.reference);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.colors, this.texture, this.reference);
            if (this.hashCode == 0) {
                this.hashCode ^= 0xFFFFFFFF;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        return "[" + String.valueOf(this.getResolvedColors()) + "]";
    }
}

