/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.color;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.serialization.Codec;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;

public class PaintColor
implements IPaintColor {
    public static final PaintColor CLEAR = new PaintColor(0, 0, SkinPaintTypes.NONE);
    public static final PaintColor WHITE = new PaintColor(-1, -1, SkinPaintTypes.NORMAL);
    private static final Cache<Integer, PaintColor> POOL = CacheBuilder.newBuilder().maximumSize(2048L).build();
    public static final Codec<IPaintColor> CODEC = Codec.INT.xmap(PaintColor::of, IPaintColor::getRawValue);
    private final int value;
    private final int rgb;
    private final ISkinPaintType paintType;

    protected PaintColor(int value, int rgb, ISkinPaintType paintType) {
        this.value = value;
        this.paintType = paintType;
        this.rgb = rgb;
    }

    public static PaintColor of(int value) {
        if (value == 0) {
            return CLEAR;
        }
        return PaintColor.of(value, PaintColor.getPaintType(value));
    }

    public static PaintColor of(int r, int g, int b, ISkinPaintType paintType) {
        return PaintColor.of(r << 16 | g << 8 | b, paintType);
    }

    public static PaintColor of(int rgb, ISkinPaintType paintType) {
        int value = rgb & 0xFFFFFF | (paintType.getId() & 0xFF) << 24;
        PaintColor paintColor = (PaintColor)POOL.getIfPresent((Object)value);
        if (paintColor == null) {
            paintColor = new PaintColor(value, rgb, paintType);
            POOL.put((Object)value, (Object)paintColor);
        }
        return paintColor;
    }

    public static ISkinPaintType getPaintType(int value) {
        return SkinPaintTypes.byId(value >> 24 & 0xFF);
    }

    public static boolean isOpaque(int color) {
        return (color & 0xFF000000) != 0;
    }

    public boolean isEmpty() {
        return this.getPaintType() == SkinPaintTypes.NONE;
    }

    @Override
    public int getRed() {
        return this.rgb >> 16 & 0xFF;
    }

    @Override
    public int getGreen() {
        return this.rgb >> 8 & 0xFF;
    }

    @Override
    public int getBlue() {
        return this.rgb & 0xFF;
    }

    @Override
    public int getRGB() {
        return this.rgb;
    }

    @Override
    public int getRawValue() {
        return this.value;
    }

    @Override
    public ISkinPaintType getPaintType() {
        return this.paintType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PaintColor)) {
            return false;
        }
        PaintColor that = (PaintColor)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.format("#%08x", this.value);
    }
}

