/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.slot;

import moe.plushie.armourers_workshop.api.common.IItemTag;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.registry.IRegistryHolder;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModItemMatchers;
import moe.plushie.armourers_workshop.init.ModItemTags;
import moe.plushie.armourers_workshop.utils.ItemMatcher;
import moe.plushie.armourers_workshop.utils.TypedRegistry;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum ItemOverrideType {
    SWORD("sword", ModItemTags.SWORDS, ModItemMatchers.SWORDS),
    SHIELD("shield", ModItemTags.SHIELDS, ModItemMatchers.SHIELDS),
    BOW("bow", ModItemTags.BOWS, ModItemMatchers.BOWS),
    TRIDENT("trident", ModItemTags.TRIDENTS, ModItemMatchers.TRIDENTS),
    PICKAXE("pickaxe", ModItemTags.PICKAXES, ModItemMatchers.PICKAXES),
    AXE("axe", ModItemTags.AXES, ModItemMatchers.AXES),
    SHOVEL("shovel", ModItemTags.SHOVELS, ModItemMatchers.SHOVELS),
    HOE("hoe", ModItemTags.HOES, ModItemMatchers.HOES),
    BOAT("boat", ModItemTags.BOATS, null),
    MINECART("minecart", ModItemTags.MINECARTS, null),
    FISHING_ROD("fishing_rod", ModItemTags.FISHING_RODS, null),
    HORSE_ARMOR("horse_armor", ModItemTags.HORSE_ARMORS, null),
    ITEM("item", null, null);

    private final IRegistryHolder<IItemTag> tag;
    private final String name;
    private final ItemMatcher matcher;

    private ItemOverrideType(String name, IRegistryHolder<IItemTag> tag, ItemMatcher matcher) {
        this.name = name;
        this.tag = tag;
        this.matcher = matcher;
    }

    @Nullable
    public static ItemOverrideType of(String name) {
        for (ItemOverrideType overrideType : ItemOverrideType.values()) {
            if (!overrideType.getName().equals(name)) continue;
            return overrideType;
        }
        return null;
    }

    public boolean isOverrideItem(ItemStack itemStack) {
        if (this == ITEM) {
            return true;
        }
        IResourceLocation registryName = TypedRegistry.findKey(itemStack.m_41720_());
        if (ModConfig.Common.overrides.contains(this.name + ":" + String.valueOf(registryName))) {
            return true;
        }
        if (this.tag != null && ((IItemTag)this.tag.get()).contains(itemStack)) {
            return true;
        }
        if (this.matcher != null) {
            return this.matcher.test(registryName, itemStack);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }
}

