/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.source;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;

public class SQLTableBuilder {
    private final String name;
    private final LinkedHashMap<String, String> fields = new LinkedHashMap();

    public SQLTableBuilder(String name) {
        this.name = name;
    }

    public void add(String name, String type) {
        this.fields.put(name, type);
    }

    public int execute(Connection connection) throws SQLException {
        int count = 0;
        String catalog = connection.getCatalog();
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet result = metaData.getTables(catalog, null, this.name, null);){
            if (!result.next()) {
                StringJoiner joiner = new StringJoiner(", ", String.format("CREATE TABLE `%s` (", this.name), ")");
                for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                    joiner.add(String.format("`%s` %s", entry.getKey(), entry.getValue()));
                }
                int n = this.execute(connection, joiner.toString());
                return n;
            }
        }
        StringJoiner joiner = new StringJoiner(";");
        for (Map.Entry<String, String> entry : this.fields.entrySet()) {
            ResultSet result = metaData.getColumns(catalog, null, this.name, entry.getKey());
            try {
                if (result.next()) continue;
                joiner.add(String.format("ALTER TABLE `%s` ADD COLUMN `%s` %s", this.name, entry.getKey(), entry.getValue()));
                ++count;
            }
            finally {
                if (result == null) continue;
                result.close();
            }
        }
        if (count != 0) {
            return this.execute(connection, joiner.toString());
        }
        return 0;
    }

    private int execute(Connection connection, String sql) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            int n = stmt.executeUpdate(sql);
            return n;
        }
    }
}

