/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.source;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import moe.plushie.armourers_workshop.api.data.IDataSource;
import moe.plushie.armourers_workshop.core.data.source.SQLTableBuilder;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.SkinUUID;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import net.minecraft.nbt.CompoundTag;

public abstract class SkinFileDataSource
implements IDataSource {
    private String lastGenUUID = "";

    public InputStream load(String id) throws Exception {
        byte[] bytes = this.query(id);
        return new ByteArrayInputStream(bytes);
    }

    public String save(InputStream stream) throws Exception {
        byte[] bytes = SkinFileUtils.readStreamToByteArray(stream);
        int hash = Arrays.hashCode(bytes);
        String identifier = this.search(hash, bytes);
        if (identifier != null) {
            return identifier;
        }
        Skin skin = SkinFileStreamUtils.loadSkinFromStream2(new ByteArrayInputStream(bytes));
        identifier = this.getFreeId();
        this.update(identifier, skin, hash, bytes);
        return identifier;
    }

    protected abstract void update(String var1, Skin var2, int var3, byte[] var4) throws Exception;

    protected abstract byte[] query(String var1) throws Exception;

    protected abstract String search(int var1, byte[] var2) throws Exception;

    protected abstract boolean contains(String var1) throws Exception;

    private String getFreeId() throws Exception {
        String uuid = this.lastGenUUID;
        while (uuid.isEmpty() || this.contains(uuid)) {
            uuid = SkinUUID.randomUUIDString();
        }
        this.lastGenUUID = uuid;
        return uuid;
    }

    public static class Fallback
    extends SkinFileDataSource {
        private final SkinFileDataSource source;
        private final SkinFileDataSource fallbackSource;

        public Fallback(SkinFileDataSource source, SkinFileDataSource fallbackSource) {
            this.source = source;
            this.fallbackSource = fallbackSource;
        }

        @Override
        public void connect() throws Exception {
            this.fallbackSource.connect();
            this.source.connect();
        }

        @Override
        public void disconnect() throws Exception {
            this.source.disconnect();
            this.fallbackSource.disconnect();
        }

        @Override
        protected void update(String id, Skin skin, int hash, byte[] bytes) throws Exception {
            this.source.update(id, skin, hash, bytes);
        }

        @Override
        protected byte[] query(String id) throws Exception {
            try {
                return this.source.query(id);
            }
            catch (FileNotFoundException exception) {
                if (this.fallbackSource.contains(id)) {
                    return this.fallbackSource.query(id);
                }
                throw exception;
            }
        }

        @Override
        protected String search(int hash, byte[] bytes) throws Exception {
            return this.source.search(hash, bytes);
        }

        @Override
        protected boolean contains(String id) throws Exception {
            return this.source.contains(id);
        }
    }

    public static class Local
    extends SkinFileDataSource {
        private static final int NODE_DATA_VERSION = 2;
        private final String name;
        private final File nodeRootPath;
        private final ExecutorService thread = ThreadUtils.newFixedThreadPool(1, "AW-SKIN-IO");
        private final Map<String, Node> nodes = new ConcurrentHashMap<String, Node>();

        public Local(File rootPath) {
            this.name = rootPath.getParentFile().getName();
            this.nodeRootPath = new File(rootPath, "objects");
        }

        @Override
        public void connect() throws Exception {
            ModLog.debug("Connect to file db: '{}'", this.name);
            this.loadNodes();
        }

        @Override
        public void disconnect() throws Exception {
            ModLog.debug("Disconnect from file db: '{}'", this.name);
            this.thread.shutdown();
        }

        @Override
        protected void update(String id, Skin skin, int hash, byte[] bytes) {
            ModLog.debug("Save file '{}' into '{}'", id, this.name);
            Node newNode = new Node(id, hash, bytes);
            newNode.save(new ByteArrayInputStream(bytes));
            this.nodes.put(newNode.id, newNode);
        }

        @Override
        protected byte[] query(String id) throws Exception {
            File parent;
            Node node = this.nodes.get(id);
            if (node == null && (parent = new File(this.nodeRootPath, id)).isDirectory()) {
                node = this.loadNode(parent);
            }
            if (node != null && node.isValid()) {
                ModLog.debug("Load skin '{}' from '{}'", id, this.name);
                return SkinFileUtils.readFileToByteArray(node.getFile());
            }
            throw new FileNotFoundException("the node '" + id + "' not found in " + this.name + "!");
        }

        @Override
        protected String search(int hash, byte[] bytes) throws Exception {
            for (Node node : this.nodes.values()) {
                if (!node.isValid() || node.fileHash != hash || !node.equalContents(bytes)) continue;
                return node.id;
            }
            return null;
        }

        @Override
        protected boolean contains(String id) throws Exception {
            return this.nodes.containsKey(id);
        }

        private void loadNodes() {
            for (File file : SkinFileUtils.listFiles(this.nodeRootPath)) {
                this.loadNode(file);
            }
        }

        private Node loadNode(File parent) {
            try {
                File indexFile = new File(parent, "0");
                CompoundTag tag = SkinFileUtils.readNBT(indexFile);
                if (tag != null) {
                    Node node = new Node(tag);
                    this.nodes.put(node.id, node);
                    return node;
                }
                Node node = this.generateNode(parent.getName(), new File(parent, "1"));
                if (node != null) {
                    this.nodes.put(node.id, node);
                    return node;
                }
            }
            catch (Exception e) {
                ModLog.error("can't load file: {}, pls try fix or remove it.", parent);
            }
            return null;
        }

        private Node generateNode(String identifier, File skinFile) throws Exception {
            if (!skinFile.isFile()) {
                return null;
            }
            byte[] bytes = SkinFileUtils.readFileToByteArray(skinFile);
            int hash = Arrays.hashCode(bytes);
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            Skin skin = SkinFileStreamUtils.loadSkinFromStream2(stream);
            if (skin == null) {
                return null;
            }
            Node node = new Node(identifier, hash, bytes);
            node.save(new ByteArrayInputStream(bytes));
            return node;
        }

        public class Node {
            final String id;
            final int version;
            final int fileSize;
            final int fileHash;

            Node(String id, int hash, byte[] bytes) {
                this.id = id;
                this.version = 2;
                this.fileSize = bytes.length;
                this.fileHash = hash;
            }

            Node(CompoundTag tag) {
                this.id = tag.m_128461_("UUID");
                this.version = tag.m_128451_("Version");
                this.fileSize = tag.m_128451_("FileSize");
                this.fileHash = tag.m_128451_("FileHash");
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("UUID", this.id);
                tag.m_128405_("Version", this.version);
                tag.m_128405_("FileSize", this.fileSize);
                tag.m_128405_("FileHash", this.fileHash);
                return tag;
            }

            public void save(InputStream inputStream) {
                Local.this.thread.execute(() -> {
                    try {
                        File skinFile = this.getFile();
                        File indexFile = this.getIndexFile();
                        SkinFileUtils.forceMkdirParent(skinFile);
                        FileOutputStream fs = new FileOutputStream(skinFile);
                        SkinFileUtils.transferTo(inputStream, fs);
                        SkinFileUtils.writeNBT(this.serializeNBT(), indexFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }

            public void remove() {
                Local.this.thread.execute(() -> {
                    File skinFile = this.getFile();
                    SkinFileUtils.deleteQuietly(skinFile.getParentFile());
                });
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Node)) {
                    return false;
                }
                Node that = (Node)o;
                return this.fileSize == that.fileSize && this.fileHash == that.fileHash;
            }

            /*
             * Enabled aggressive exception aggregation
             */
            public boolean equalContents(byte[] bytes) {
                int index;
                try (FileInputStream stream = new FileInputStream(this.getFile());){
                    int readSize;
                    byte[] buff = new byte[1024];
                    for (index = 0; index < bytes.length; index += readSize) {
                        readSize = stream.read(buff);
                        if (readSize <= 0) {
                            break;
                        }
                        if (index + readSize > bytes.length) {
                            boolean bl = false;
                            return bl;
                        }
                        for (int i = 0; i < readSize; ++i) {
                            if (bytes[index + i] == buff[i]) continue;
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return index == bytes.length;
            }

            public int hashCode() {
                return Objects.hash(this.fileSize, this.fileHash);
            }

            public File getFile() {
                return new File(Local.this.nodeRootPath, this.id + "/1");
            }

            public File getIndexFile() {
                return new File(Local.this.nodeRootPath, this.id + "/0");
            }

            public boolean isValid() {
                return this.getFile().exists();
            }
        }
    }

    public static class SQL
    extends SkinFileDataSource {
        private final String name;
        private final Connection connection;
        private PreparedStatement insertStatement;
        private PreparedStatement existsStatement;
        private PreparedStatement searchStatement;
        private PreparedStatement queryStatement;

        public SQL(String name, Connection connection) {
            this.name = name;
            this.connection = connection;
        }

        @Override
        public void connect() throws SQLException {
            ModLog.debug("Connect to file db: '{}'", this.name);
            SQLTableBuilder builder = new SQLTableBuilder("Skin");
            builder.add("id", "VARCHAR(48) NOT NULL PRIMARY KEY");
            builder.add("type", "VARCHAR(48)");
            builder.add("created_at", "TIMESTAMP");
            builder.add("name", "VARCHAR(512)");
            builder.add("flavour", "VARCHAR(1024)");
            builder.add("author", "VARCHAR(48)");
            builder.add("hash", "INT NOT NULL");
            builder.add("file", "LONGBLOB NOT NULL");
            builder.execute(this.connection);
            this.queryStatement = this.connection.prepareStatement("SELECT `file` FROM `Skin` where `id` = (?)");
            this.searchStatement = this.connection.prepareStatement("SELECT `id`, `file` FROM `Skin` where `hash` = (?)");
            this.existsStatement = this.connection.prepareStatement("SELECT `id` FROM `Skin` where `id` = (?)");
            this.insertStatement = this.connection.prepareStatement("INSERT INTO `Skin` (`id`, `type`, `author`, `name`, `flavour`, `created_at`, `hash`, `file`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        }

        @Override
        public void disconnect() throws SQLException {
            ModLog.debug("Disconnect from file db: '{}'", this.name);
            ObjectUtils.safeClose(this.insertStatement);
            ObjectUtils.safeClose(this.existsStatement);
            ObjectUtils.safeClose(this.searchStatement);
            ObjectUtils.safeClose(this.queryStatement);
            this.connection.close();
        }

        @Override
        protected void update(String id, Skin skin, int hash, byte[] bytes) throws SQLException {
            ModLog.debug("Save file '{}' into '{}'", id, this.name);
            this.insertStatement.setString(1, id);
            this.insertStatement.setString(2, skin.getType().getRegistryName().toString());
            this.insertStatement.setString(3, skin.getAuthorUUID());
            this.insertStatement.setString(4, skin.getCustomName());
            this.insertStatement.setString(5, skin.getFlavourText());
            this.insertStatement.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            this.insertStatement.setInt(7, hash);
            this.insertStatement.setBytes(8, bytes);
            this.insertStatement.executeUpdate();
        }

        @Override
        protected byte[] query(String id) throws Exception {
            this.queryStatement.setString(1, id);
            try (ResultSet result = this.queryStatement.executeQuery();){
                if (result.next()) {
                    ModLog.debug("Load skin '{}' from '{}'", id, this.name);
                    byte[] byArray = result.getBytes(1);
                    return byArray;
                }
            }
            throw new FileNotFoundException("the file '" + id + "' not found in " + this.name + "!");
        }

        @Override
        protected String search(int hash, byte[] bytes) throws SQLException {
            this.searchStatement.setInt(1, hash);
            try (ResultSet result = this.searchStatement.executeQuery();){
                while (result.next()) {
                    byte[] bytes2 = result.getBytes(2);
                    if (!Arrays.equals(bytes, bytes2)) continue;
                    String string = result.getString(1);
                    return string;
                }
                String string = null;
                return string;
            }
        }

        @Override
        protected boolean contains(String id) throws SQLException {
            this.existsStatement.setString(1, id);
            try (ResultSet result = this.existsStatement.executeQuery();){
                boolean bl = result.next();
                return bl;
            }
        }
    }
}

