/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.transform;

import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class SkinItemTransforms
extends LinkedHashMap<String, ITransformf> {
    public SkinItemTransforms() {
    }

    public SkinItemTransforms(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            this.put(key, this.deserializeTransform(nbt.m_128437_(key, 5)));
        }
    }

    @Override
    public void put(AbstractItemTransformType key, ITransformf value) {
        this.put(key.getName(), value);
    }

    public ITransformf get(AbstractItemTransformType key) {
        return (ITransformf)super.get(key.getName());
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.forEach((key, value) -> nbt.m_128365_(key, (Tag)this.serializeTransform((ITransformf)value)));
        return nbt;
    }

    private ListTag serializeTransform(ITransformf transform) {
        ListTag tag = new ListTag();
        if (transform.isIdentity()) {
            return tag;
        }
        IVector3f translate = transform.getTranslate();
        tag.add((Object)FloatTag.m_128566_((float)translate.getX()));
        tag.add((Object)FloatTag.m_128566_((float)translate.getY()));
        tag.add((Object)FloatTag.m_128566_((float)translate.getZ()));
        IVector3f rotation = transform.getRotation();
        tag.add((Object)FloatTag.m_128566_((float)rotation.getX()));
        tag.add((Object)FloatTag.m_128566_((float)rotation.getY()));
        tag.add((Object)FloatTag.m_128566_((float)rotation.getZ()));
        IVector3f scale = transform.getScale();
        tag.add((Object)FloatTag.m_128566_((float)scale.getX()));
        tag.add((Object)FloatTag.m_128566_((float)scale.getY()));
        tag.add((Object)FloatTag.m_128566_((float)scale.getZ()));
        return tag;
    }

    private ITransformf deserializeTransform(ListTag tag) {
        if (tag.isEmpty() || tag.size() < 9) {
            return SkinTransform.IDENTITY;
        }
        float tx = tag.m_128775_(0);
        float ty = tag.m_128775_(1);
        float tz = tag.m_128775_(2);
        Vector3f translate = new Vector3f(tx, ty, tz);
        float rx = tag.m_128775_(3);
        float ry = tag.m_128775_(4);
        float rz = tag.m_128775_(5);
        Vector3f rotation = new Vector3f(rx, ry, rz);
        float sx = tag.m_128775_(6);
        float sy = tag.m_128775_(7);
        float sz = tag.m_128775_(8);
        Vector3f scale = new Vector3f(sx, sy, sz);
        return SkinTransform.create(translate, rotation, scale);
    }
}

