/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.action.ICanRotation;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinWingsTransform;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;

public class SkinPartTransform
implements ISkinTransform {
    public static final SkinPartTransform IDENTITY = new SkinPartTransform();
    private final ArrayList<ISkinTransform> children = new ArrayList();

    public SkinPartTransform() {
    }

    public SkinPartTransform(SkinPart part, ISkinTransform quadsTransform) {
        ISkinTransform partTransform;
        ISkinTransform wingsTransform;
        if (quadsTransform != null) {
            this.children.add(quadsTransform);
        }
        if ((wingsTransform = this.getWingsTransform(part)) != null) {
            this.children.add(wingsTransform);
        }
        if ((partTransform = part.getTransform()) != null) {
            this.children.add(partTransform);
        }
    }

    private ISkinTransform getWingsTransform(SkinPart part) {
        ISkinPartType partType = part.getType();
        if (!(partType instanceof ICanRotation)) {
            return null;
        }
        Collection<SkinMarker> markers = part.getMarkers();
        if (markers == null || markers.isEmpty()) {
            return null;
        }
        return new SkinWingsTransform(partType, part.getProperties(), markers.iterator().next());
    }

    @Override
    public void apply(IPoseStack poseStack) {
        for (ISkinTransform transform : this.children) {
            transform.apply(poseStack);
        }
    }

    public void addChild(ISkinTransform transform) {
        this.children.add(transform);
    }

    public void insertChild(ISkinTransform transform, int index) {
        this.children.add(index, transform);
    }

    public void replaceChild(ISkinTransform oldTransform, ISkinTransform newTransform) {
        int index = this.children.indexOf(oldTransform);
        if (index != -1) {
            this.children.set(index, newTransform);
        }
    }

    public void removeChild(ISkinTransform transform) {
        this.children.remove(transform);
    }

    public List<ISkinTransform> getChildren() {
        return this.children;
    }

    public boolean isIdentity() {
        for (ISkinTransform transform : this.children) {
            ITransformf transform1;
            if (transform instanceof ITransformf && (transform1 = (ITransformf)((Object)transform)).isIdentity()) continue;
            return false;
        }
        return true;
    }
}

