/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.transform;

import java.io.IOException;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class SkinTransform
implements ITransformf,
ISkinTransform {
    public static final int BYTES = 64;
    public static final SkinTransform IDENTITY = new SkinTransform();
    private Vector3f translate = Vector3f.ZERO;
    private Vector3f rotation = Vector3f.ZERO;
    private Vector3f scale = Vector3f.ONE;
    private Vector3f afterTranslate = Vector3f.ZERO;
    private Vector3f pivot = Vector3f.ZERO;

    public static SkinTransform create(Vector3f translate, Vector3f rotation, Vector3f scale) {
        return SkinTransform.create(translate, rotation, scale, Vector3f.ZERO, Vector3f.ZERO);
    }

    public static SkinTransform create(Vector3f translate, Vector3f rotation, Vector3f scale, Vector3f pivot, Vector3f afterTranslate) {
        if (translate.equals(Vector3f.ZERO) && rotation.equals(Vector3f.ZERO) && scale.equals(Vector3f.ONE) && pivot.equals(Vector3f.ZERO) && afterTranslate.equals(Vector3f.ZERO)) {
            return IDENTITY;
        }
        SkinTransform transform = new SkinTransform();
        transform.translate = translate;
        transform.rotation = rotation;
        transform.scale = scale;
        transform.afterTranslate = afterTranslate;
        transform.pivot = pivot;
        return transform;
    }

    public static SkinTransform createRotationTransform(Vector3f rotation) {
        if (!rotation.equals(Vector3f.ZERO)) {
            SkinTransform transform = new SkinTransform();
            transform.rotation = rotation;
            return transform;
        }
        return IDENTITY;
    }

    public static SkinTransform createScaleTransform(float sx, float sy, float sz) {
        if (sx != 1.0f || sy != 1.0f || sz != 1.0f) {
            SkinTransform transform = new SkinTransform();
            transform.scale = new Vector3f(sx, sy, sz);
            return transform;
        }
        return IDENTITY;
    }

    public static SkinTransform createScaleTransform(Vector3f scale) {
        if (!scale.equals(Vector3f.ONE)) {
            SkinTransform transform = new SkinTransform();
            transform.scale = scale;
            return transform;
        }
        return IDENTITY;
    }

    public static SkinTransform createTranslateTransform(float tx, float ty, float tz) {
        if (tx != 0.0f || ty != 0.0f || tz != 0.0f) {
            SkinTransform transform = new SkinTransform();
            transform.translate = new Vector3f(tx, ty, tz);
            return transform;
        }
        return IDENTITY;
    }

    public static SkinTransform createTranslateTransform(Vector3f offset) {
        if (!offset.equals(Vector3f.ZERO)) {
            SkinTransform transform = new SkinTransform();
            transform.translate = offset;
            return transform;
        }
        return IDENTITY;
    }

    @Override
    public void apply(IPoseStack poseStack) {
        if (this == IDENTITY) {
            return;
        }
        if (this.translate != Vector3f.ZERO) {
            poseStack.translate(this.translate.getX(), this.translate.getY(), this.translate.getZ());
        }
        if (this.rotation != Vector3f.ZERO) {
            if (this.pivot != Vector3f.ZERO) {
                poseStack.translate(this.pivot.getX(), this.pivot.getY(), this.pivot.getZ());
            }
            poseStack.rotate(OpenQuaternionf.fromZYX(this.rotation, true));
            if (this.pivot != Vector3f.ZERO) {
                poseStack.translate(-this.pivot.getX(), -this.pivot.getY(), -this.pivot.getZ());
            }
        }
        if (this.scale != Vector3f.ONE) {
            poseStack.scale(this.scale.getX(), this.scale.getY(), this.scale.getZ());
        }
        if (this.afterTranslate != Vector3f.ZERO) {
            poseStack.translate(this.afterTranslate.getX(), this.afterTranslate.getY(), this.afterTranslate.getZ());
        }
    }

    public void readFromStream(IInputStream stream) throws IOException {
        int flags = stream.readInt();
        this.translate = this.optimize(stream.readVector3f(), Vector3f.ZERO);
        this.rotation = this.optimize(stream.readVector3f(), Vector3f.ZERO);
        this.scale = this.optimize(stream.readVector3f(), Vector3f.ONE);
        this.afterTranslate = this.optimize(stream.readVector3f(), Vector3f.ZERO);
        this.pivot = this.optimize(stream.readVector3f(), Vector3f.ZERO);
    }

    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeInt(0);
        stream.writeVector3f(this.translate);
        stream.writeVector3f(this.rotation);
        stream.writeVector3f(this.scale);
        stream.writeVector3f(this.afterTranslate);
        stream.writeVector3f(this.pivot);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinTransform)) {
            return false;
        }
        SkinTransform that = (SkinTransform)o;
        return this.translate.equals(that.translate) && this.rotation.equals(that.rotation) && this.scale.equals(that.scale) && this.pivot.equals(that.pivot) && this.afterTranslate.equals(that.afterTranslate);
    }

    public int hashCode() {
        return Objects.hash(this.translate, this.rotation, this.scale, this.pivot, this.afterTranslate);
    }

    @Override
    public boolean isIdentity() {
        return this == IDENTITY;
    }

    @Override
    public Vector3f getTranslate() {
        return this.translate;
    }

    @Override
    public Vector3f getRotation() {
        return this.rotation;
    }

    @Override
    public Vector3f getScale() {
        return this.scale;
    }

    @Override
    public Vector3f getAfterTranslate() {
        return this.afterTranslate;
    }

    @Override
    public Vector3f getPivot() {
        return this.pivot;
    }

    private <T> T optimize(T value, T targetValue) {
        if (value.equals(targetValue)) {
            return targetValue;
        }
        return value;
    }
}

