/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.transform;

import moe.plushie.armourers_workshop.api.action.ICanRotation;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class SkinWingsTransform
implements ISkinTransform {
    private float animationTicks = 0.0f;
    private boolean isFallFlying = false;
    private final boolean isMirror;
    private final SkinMarker marker;
    private final SkinProperties properties;

    public SkinWingsTransform(ISkinPartType partType, SkinProperties properties, SkinMarker marker) {
        ICanRotation rotatableType;
        this.marker = marker;
        this.properties = properties;
        this.isMirror = partType instanceof ICanRotation && (rotatableType = (ICanRotation)((Object)partType)).isMirror();
    }

    public static boolean isFlying(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35935_) {
                return true;
            }
        }
        return entity.m_21255_();
    }

    public void setup(@Nullable Entity entity, float animationTicks) {
        LivingEntity livingEntity;
        this.animationTicks = animationTicks;
        this.isFallFlying = entity instanceof LivingEntity && SkinWingsTransform.isFlying(livingEntity = (LivingEntity)entity);
    }

    @Override
    public void apply(IPoseStack poseStack) {
        Direction dir = this.marker.getDirection();
        if (dir == null) {
            return;
        }
        Vector3i point = this.marker.getPosition();
        float angle = (float)this.getRotationDegrees();
        Vector3f offset = new Vector3f((float)point.getX() + 0.5f, (float)point.getY() + 0.5f, (float)point.getZ() + 0.5f);
        if (!this.isMirror) {
            angle = -angle;
        }
        poseStack.translate(offset.getX(), offset.getY(), offset.getZ());
        poseStack.rotate(this.getRotationMatrix(dir).rotationDegrees(angle));
        poseStack.translate(-offset.getX(), -offset.getY(), -offset.getZ());
    }

    private double getRotationDegrees() {
        if (this.properties == null) {
            return 0.0;
        }
        Double maxAngle = this.properties.get(SkinProperty.WINGS_MAX_ANGLE);
        Double minAngle = this.properties.get(SkinProperty.WINGS_MIN_ANGLE);
        String movementTypeName = this.properties.get(SkinProperty.WINGS_MOVMENT_TYPE);
        SkinProperty.MovementType movementType = SkinProperty.MovementType.valueOf(movementTypeName);
        Double flapTime = this.properties.get(SkinProperty.WINGS_IDLE_SPEED);
        if (this.isFallFlying) {
            flapTime = this.properties.get(SkinProperty.WINGS_FLYING_SPEED);
        }
        double finalFlapTime = Math.max(flapTime / 1000.0, (double)0.1f);
        double angle = (double)this.animationTicks % finalFlapTime;
        if (movementType == SkinProperty.MovementType.EASE) {
            angle = Math.sin(angle / finalFlapTime * Math.PI * 2.0);
        }
        if (movementType == SkinProperty.MovementType.LINEAR) {
            angle /= finalFlapTime;
        }
        double fullAngle = maxAngle - minAngle;
        if (movementType == SkinProperty.MovementType.LINEAR) {
            return fullAngle * angle;
        }
        return -minAngle.doubleValue() - fullAngle * ((angle + 1.0) / 2.0);
    }

    private Vector3f getRotationMatrix(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Vector3f.YP;
            case Direction.DOWN -> Vector3f.YN;
            case Direction.SOUTH -> Vector3f.ZN;
            case Direction.NORTH -> Vector3f.ZP;
            case Direction.EAST -> Vector3f.XP;
            case Direction.WEST -> Vector3f.XN;
        };
    }
}

