/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;

public class EntityProfile {
    private final IResourceLocation registryName;
    private final Map<SkinSlotType, Function<SkinSlotType, Integer>> supports;
    private final Collection<IEntityTypeProvider<?>> entities;
    private final boolean locked;

    public EntityProfile(IResourceLocation registryName, Map<SkinSlotType, Function<SkinSlotType, Integer>> supports, Collection<IEntityTypeProvider<?>> entities, boolean locked) {
        this.registryName = registryName;
        this.supports = supports;
        this.entities = entities;
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isSupported(SkinSlotType slotType) {
        return this.supports.containsKey((Object)slotType);
    }

    public int getMaxCount(SkinSlotType slotType) {
        Function<SkinSlotType, Integer> provider = this.supports.get((Object)slotType);
        if (provider != null) {
            return provider.apply(slotType);
        }
        if (slotType == SkinSlotType.DEFAULT) {
            return slotType.getMaxSize();
        }
        return 0;
    }

    public Collection<SkinSlotType> getSlots() {
        return this.supports.keySet();
    }

    public Collection<IEntityTypeProvider<?>> getEntities() {
        return this.entities;
    }

    public IResourceLocation getRegistryName() {
        return this.registryName;
    }
}

