/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.holiday;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import moe.plushie.armourers_workshop.api.data.IDataSerializer;
import moe.plushie.armourers_workshop.compatibility.core.AbstractSavedData;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.storage.DimensionDataStorage.DataProvider;
import moe.plushie.armourers_workshop.core.holiday.Holiday;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.DataSerializerKey;
import moe.plushie.armourers_workshop.utils.DataTypeCodecs;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public class HolidayTracker
extends AbstractSavedData {
    private static final DataSerializerKey<List<String>> LOG_KEY = DataSerializerKey.create("Logs", DataTypeCodecs.STRING.listOf(), Collections.emptyList());
    private final Calendar calendar = Calendar.getInstance();
    private final HashSet<String> logs = new HashSet();

    public static HolidayTracker of(MinecraftServer server) {
        return DataProvider.computeIfAbsent(server.m_129783_().m_8895_(), HolidayTracker::new, 0, "HolidayTracker");
    }

    public void add(Player player, Holiday holiday) {
        ModLog.info("give a {} gift sack for the {}", holiday.getName(), player.m_6302_());
        this.logs.add(this.getKey(player, holiday));
        this.m_77762_();
    }

    public void remove(Player player, Holiday holiday) {
        ModLog.info("take a {} gift sack for the {}", holiday.getName(), player.m_6302_());
        this.logs.remove(this.getKey(player, holiday));
        this.m_77762_();
    }

    public boolean has(Player player, Holiday holiday) {
        return this.logs.contains(this.getKey(player, holiday));
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.logs.clear();
        String prefix = this.calendar.get(1) + ":";
        for (String log : serializer.read(LOG_KEY)) {
            if (!log.startsWith(prefix)) continue;
            this.logs.add(log);
        }
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        String prefix = this.calendar.get(1) + ":";
        ArrayList<String> logs = new ArrayList<String>();
        for (String log : logs) {
            if (!log.startsWith(prefix)) continue;
            logs.add(log);
        }
        serializer.write(LOG_KEY, logs);
    }

    private String getKey(Player player, Holiday holiday) {
        return this.calendar.get(1) + ":" + holiday.getName() + ":" + player.m_20149_();
    }
}

