/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IDataComponentType;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LinkingToolItem
extends FlavouredItem
implements IItemHandler,
IItemPropertiesProvider {
    public LinkingToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> {
            if (ComponentAPI.has(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get())) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    @Override
    public InteractionResult useOnFirst(ItemStack itemStack, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (level.m_5776_() || player == null) {
            return InteractionResult.SUCCESS;
        }
        BlockPos linkedBlockPos = (BlockPos)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
        SkinnableBlockEntity blockEntity = this.getTitleEntity(level, context.m_8083_());
        if (blockEntity != null && player.m_36341_()) {
            blockEntity.setLinkedBlockPos(null);
            player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.clear"));
            return InteractionResult.SUCCESS;
        }
        if (linkedBlockPos != null) {
            ComponentAPI.remove(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
            if (blockEntity != null) {
                blockEntity.setLinkedBlockPos(linkedBlockPos);
                player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.finish"));
                return InteractionResult.SUCCESS;
            }
            player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.fail"));
            return InteractionResult.SUCCESS;
        }
        if (blockEntity != null) {
            player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.linkedToSkinnable"));
            return InteractionResult.FAIL;
        }
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get(), context.m_8083_());
        player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.start"));
        return InteractionResult.SUCCESS;
    }

    private SkinnableBlockEntity getTitleEntity(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            return (SkinnableBlockEntity)blockEntity;
        }
        return null;
    }
}

