/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.world.entity.player.Player;

public class ResponseSkinPacket
extends CustomPacket {
    private final String identifier;
    private final Mode mode;
    private final boolean compress;
    private final Exception exp;
    private final Skin skin;

    public ResponseSkinPacket(String identifier, Skin skin, Exception exp) {
        this.identifier = identifier;
        this.exp = exp;
        this.skin = skin;
        this.mode = skin != null ? Mode.STREAM : Mode.EXCEPTION;
        this.compress = ModConfig.Common.enableServerCompressesSkins;
    }

    public ResponseSkinPacket(IFriendlyByteBuf buffer) {
        this.identifier = buffer.readUtf();
        this.mode = buffer.readEnum(Mode.class);
        this.compress = buffer.readBoolean();
        this.exp = this.readException(buffer);
        this.skin = this.readSkinStream(buffer);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeUtf(this.identifier);
        buffer.writeEnum(this.mode);
        buffer.writeBoolean(this.compress);
        this.writeException(buffer, this.exp);
        this.writeSkinStream(buffer, this.skin);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        SkinLoader.getInstance().addSkin(this.identifier, this.skin, this.exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception readException(IFriendlyByteBuf buffer) {
        Exception exception;
        if (this.mode != Mode.EXCEPTION) {
            return null;
        }
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = this.createInputStream(buffer);
            objectInputStream = new ObjectInputStream(inputStream);
            exception = (Exception)objectInputStream.readObject();
        }
        catch (Exception exception2) {
            Exception exception3;
            try {
                exception3 = exception2;
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(objectInputStream, inputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(objectInputStream, inputStream);
            return exception3;
        }
        StreamUtils.closeQuietly(objectInputStream, inputStream);
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeException(IFriendlyByteBuf buffer, Exception exception) {
        if (this.mode != Mode.EXCEPTION) {
            return;
        }
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = this.createOutputStream(buffer);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(exception);
        }
        catch (Exception exception1) {
            try {
                exception1.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(objectOutputStream, outputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(objectOutputStream, outputStream);
        }
        StreamUtils.closeQuietly(objectOutputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Skin readSkinStream(IFriendlyByteBuf buffer) {
        Skin skin;
        if (this.mode != Mode.STREAM) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.createInputStream(buffer);
            skin = SkinFileStreamUtils.loadSkinFromStream(inputStream);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(inputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(inputStream);
            return null;
        }
        StreamUtils.closeQuietly(inputStream);
        return skin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSkinStream(IFriendlyByteBuf buffer, Skin skin) {
        if (this.mode != Mode.STREAM) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = this.createOutputStream(buffer);
            SkinFileStreamUtils.saveSkinToStream(outputStream, skin);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(outputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(outputStream);
        }
        StreamUtils.closeQuietly(outputStream);
    }

    private InputStream createInputStream(IFriendlyByteBuf buffer) throws Exception {
        ByteBufInputStream inputStream = new ByteBufInputStream(buffer.asByteBuf());
        if (this.compress) {
            return new GZIPInputStream((InputStream)inputStream);
        }
        return inputStream;
    }

    private OutputStream createOutputStream(IFriendlyByteBuf buffer) throws Exception {
        ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer.asByteBuf());
        if (this.compress) {
            return new GZIPOutputStream((OutputStream)outputStream);
        }
        return outputStream;
    }

    public static enum Mode {
        EXCEPTION,
        STREAM;

    }
}

