/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentProvider;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentTypes;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateSkinDocumentPacket
extends CustomPacket {
    private static final HashMap<Class<? extends Action>, Mode> ALL_ACTIONS = new HashMap();
    private String operator;
    private final BlockPos pos;
    private final Action action;

    public UpdateSkinDocumentPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.operator = buffer.readUtf();
        Mode mode = buffer.readEnum(Mode.class);
        this.action = mode.read(buffer);
    }

    public UpdateSkinDocumentPacket(BlockEntity entity, Action action) {
        this.pos = entity.m_58899_();
        this.action = action;
        this.operator = "";
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(this.operator);
        buffer.writeEnum(ALL_ACTIONS.getOrDefault(this.action.getClass(), Mode.CHANGE_TYPE));
        this.action.encode(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        BlockEntity blockEntity = PropertyProvider.getLevel((Entity)player).m_7702_(this.pos);
        if (blockEntity instanceof SkinDocumentProvider) {
            SkinDocumentProvider provider = (SkinDocumentProvider)blockEntity;
            ModLog.debug("the document {} accepted for '{}'", this.action, player.m_6302_());
            SkinDocument document = provider.getDocument();
            document.beginEditing();
            this.action.execute(document, (Player)player);
            document.endEditing();
            if (!(this.action instanceof ChangeTypeAction)) {
                this.operator = player.m_20149_();
                NetworkManager.sendToTrackingBlock(this, blockEntity);
            }
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        if (this.operator.equals(player.m_20149_())) {
            return;
        }
        BlockEntity blockEntity = PropertyProvider.getLevel((Entity)player).m_7702_(this.pos);
        if (blockEntity instanceof SkinDocumentProvider) {
            SkinDocumentProvider provider = (SkinDocumentProvider)blockEntity;
            ModLog.debug("the document {} accepted for server", this.action);
            SkinDocument document = provider.getDocument();
            document.beginEditing();
            this.action.execute(document, player);
            document.endEditing();
        }
    }

    public static enum Mode {
        CHANGE_TYPE(ChangeTypeAction.class, ChangeTypeAction::new),
        UPDATE_SETTINGS(UpdateSettingsAction.class, UpdateSettingsAction::new),
        UPDATE_PROPERTIES(UpdatePropertiesAction.class, UpdatePropertiesAction::new),
        INSERT_NODE(InsertNodeAction.class, InsertNodeAction::new),
        UPDATE_NODE(UpdateNodeAction.class, UpdateNodeAction::new),
        REMOVE_NODE(RemoveNodeAction.class, RemoveNodeAction::new),
        MOVE_NODE(MoveNodeAction.class, MoveNodeAction::new);

        final Function<IFriendlyByteBuf, ? extends Action> actionFactory;

        private Mode(Class<? extends Action> actionClass, Function<IFriendlyByteBuf, Action> actionFactory) {
            this.actionFactory = actionFactory;
            ALL_ACTIONS.put(actionClass, this);
        }

        public Action read(IFriendlyByteBuf buf) {
            return this.actionFactory.apply(buf);
        }
    }

    public static abstract class Action {
        public abstract void encode(IFriendlyByteBuf var1);

        public abstract void execute(SkinDocument var1, Player var2);

        protected String makeDescription(String action, Object ... args) {
            StringBuilder builder = new StringBuilder();
            builder.append(action);
            builder.append("(");
            for (int i = 0; i < args.length; i += 2) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(args[i]);
                builder.append(":");
                builder.append(args[i + 1]);
            }
            builder.append(")");
            return builder.toString();
        }
    }

    public static class ChangeTypeAction
    extends Action {
        private final SkinDocumentType type;

        public ChangeTypeAction(SkinDocumentType type) {
            this.type = type;
        }

        public ChangeTypeAction(IFriendlyByteBuf buf) {
            this.type = SkinDocumentTypes.byName(buf.readUtf());
        }

        @Override
        public void encode(IFriendlyByteBuf buffer) {
            buffer.writeUtf(this.type.getRegistryName().toString());
        }

        @Override
        public void execute(SkinDocument document, Player player) {
            document.setType(this.type);
        }

        public String toString() {
            return this.makeDescription("changeType", "type", this.type.getRegistryName());
        }
    }

    public static class MoveNodeAction
    extends Action {
        private final String id;
        private final String targetId;
        private final int targetIndex;

        public MoveNodeAction(String id, String targetId, int targetIndex) {
            this.id = id;
            this.targetId = targetId;
            this.targetIndex = targetIndex;
        }

        public MoveNodeAction(IFriendlyByteBuf buf) {
            this.id = buf.readUtf();
            this.targetId = buf.readUtf();
            this.targetIndex = buf.readInt();
        }

        @Override
        public void encode(IFriendlyByteBuf buf) {
            buf.writeUtf(this.id);
            buf.writeUtf(this.targetId);
            buf.writeInt(this.targetIndex);
        }

        @Override
        public void execute(SkinDocument document, Player player) {
            SkinDocumentNode parent = document.nodeById(this.id);
            SkinDocumentNode target = document.nodeById(this.targetId);
            if (parent != null && target != null) {
                parent.moveTo(target, this.targetIndex);
            }
        }

        public String toString() {
            return this.makeDescription("moveNode", "id", this.id, "tid", this.targetId, "ti", this.targetIndex);
        }
    }

    public static class RemoveNodeAction
    extends Action {
        private final String id;

        public RemoveNodeAction(String id) {
            this.id = id;
        }

        public RemoveNodeAction(IFriendlyByteBuf buf) {
            this.id = buf.readUtf();
        }

        @Override
        public void encode(IFriendlyByteBuf buf) {
            buf.writeUtf(this.id);
        }

        @Override
        public void execute(SkinDocument document, Player player) {
            SkinDocumentNode target = document.nodeById(this.id);
            if (target != null) {
                target.removeFromParent();
            }
        }

        public String toString() {
            return this.makeDescription("removeNode", "id", this.id);
        }
    }

    public static class UpdateNodeAction
    extends Action {
        private final String id;
        private final CompoundTag tag;

        public UpdateNodeAction(String id, CompoundTag tag) {
            this.id = id;
            this.tag = tag;
        }

        public UpdateNodeAction(IFriendlyByteBuf buf) {
            this.id = buf.readUtf();
            this.tag = buf.readNbt();
        }

        @Override
        public void encode(IFriendlyByteBuf buf) {
            buf.writeUtf(this.id);
            buf.writeNbt(this.tag);
        }

        @Override
        public void execute(SkinDocument document, Player player) {
            SkinDocumentNode target = document.nodeById(this.id);
            if (target != null) {
                target.deserializeNBT(this.tag);
            }
        }

        public String toString() {
            return this.makeDescription("updateNode", "id", this.id, "tag", this.tag);
        }
    }

    public static class InsertNodeAction
    extends Action {
        private final String id;
        private final int targetIndex;
        private final CompoundTag tag;

        public InsertNodeAction(String id, int targetIndex, CompoundTag tag) {
            this.id = id;
            this.targetIndex = targetIndex;
            this.tag = tag;
        }

        public InsertNodeAction(IFriendlyByteBuf buf) {
            this.id = buf.readUtf();
            this.targetIndex = buf.readInt();
            this.tag = buf.readNbt();
        }

        @Override
        public void encode(IFriendlyByteBuf buf) {
            buf.writeUtf(this.id);
            buf.writeInt(this.targetIndex);
            buf.writeNbt(this.tag);
        }

        @Override
        public void execute(SkinDocument document, Player player) {
            SkinDocumentNode target = document.nodeById(this.id);
            if (target != null) {
                SkinDocumentNode newValue = new SkinDocumentNode(this.tag);
                target.insertAtIndex(newValue, this.targetIndex);
            }
        }

        public String toString() {
            return this.makeDescription("insertNode", "id", this.id, "ti", this.targetIndex, "tag", this.tag);
        }
    }

    public static class UpdatePropertiesAction
    extends Action {
        private final CompoundTag tag;

        public UpdatePropertiesAction(CompoundTag tag) {
            this.tag = tag;
        }

        public UpdatePropertiesAction(IFriendlyByteBuf buf) {
            this.tag = buf.readNbt();
        }

        @Override
        public void encode(IFriendlyByteBuf buf) {
            buf.writeNbt(this.tag);
        }

        @Override
        public void execute(SkinDocument document, Player player) {
            document.updateProperties(this.tag);
        }

        public String toString() {
            return this.makeDescription("updateProperties", "tag", this.tag);
        }
    }

    public static class UpdateSettingsAction
    extends Action {
        private final CompoundTag tag;

        public UpdateSettingsAction(CompoundTag tag) {
            this.tag = tag;
        }

        public UpdateSettingsAction(IFriendlyByteBuf buf) {
            this.tag = buf.readNbt();
        }

        @Override
        public void encode(IFriendlyByteBuf buf) {
            buf.writeNbt(this.tag);
        }

        @Override
        public void execute(SkinDocument document, Player player) {
            document.updateSettings(this.tag);
        }

        public String toString() {
            return this.makeDescription("updateSettings", "tag", this.tag);
        }
    }
}

