/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.ISkin;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.texture.SkinPreviewData;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;

public class Skin
implements ISkin {
    private final int id = ThreadUtils.nextId(Skin.class);
    private final SkinSettings settings;
    private final SkinProperties properties;
    private final ISkinType skinType;
    private final List<SkinPart> parts;
    private final List<SkinAnimation> animations;
    private Object blobs;
    private HashMap<BlockPos, Rectangle3i> blockBounds;
    private int version;
    private final SkinPaintData paintData;
    private final SkinPreviewData previewData;

    public Skin(ISkinType skinType, SkinProperties properties, SkinSettings settings, SkinPaintData paintData, SkinPreviewData previewData, Collection<SkinAnimation> skinAnimations, Collection<SkinPart> skinParts) {
        this.properties = properties;
        this.settings = settings;
        this.skinType = skinType;
        this.paintData = paintData;
        this.previewData = previewData;
        this.animations = new ArrayList<SkinAnimation>(skinAnimations);
        this.parts = new ArrayList<SkinPart>(skinParts);
    }

    public int getId() {
        return this.id;
    }

    public SkinSettings getSettings() {
        return this.settings;
    }

    public SkinProperties getProperties() {
        return this.properties;
    }

    public Map<BlockPos, Rectangle3i> getBlockBounds() {
        if (this.blockBounds != null) {
            return this.blockBounds;
        }
        this.blockBounds = new HashMap();
        if (this.skinType != SkinTypes.BLOCK) {
            return this.blockBounds;
        }
        List<Rectangle3i> collisionBox = this.settings.getCollisionBox();
        this.blockBounds.put(BlockPos.f_121853_, Rectangle3i.ZERO);
        if (collisionBox != null) {
            for (Rectangle3i rect : collisionBox) {
                int bx = -Math.floorDiv(rect.getMinX(), 16);
                int by = -Math.floorDiv(rect.getMinY(), 16);
                int bz = Math.floorDiv(rect.getMinZ(), 16);
                int tx = Math.floorMod(rect.getMinX(), 16) - 8;
                int ty = Math.floorMod(rect.getMinY(), 16) - 8;
                int tz = Math.floorMod(rect.getMinZ(), 16) - 8;
                int tw = rect.getWidth();
                int th = rect.getHeight();
                int td = rect.getDepth();
                this.blockBounds.put(new BlockPos(bx, by, bz), new Rectangle3i(-tx, -ty, tz, -tw, -th, td));
            }
            return this.blockBounds;
        }
        for (SkinPart part : this.getParts()) {
            HashMap<BlockPos, Rectangle3i> partBlockBounds = part.getBlockBounds();
            if (partBlockBounds == null) continue;
            this.blockBounds.putAll(partBlockBounds);
        }
        return this.blockBounds;
    }

    public int getModelCount() {
        int count = 0;
        for (SkinPart part : this.parts) {
            count += part.getModelCount();
        }
        return count;
    }

    public int getPartCount() {
        return this.parts.size();
    }

    @Override
    public ISkinType getType() {
        return this.skinType;
    }

    @Nullable
    public SkinPaintData getPaintData() {
        return this.paintData;
    }

    public SkinPreviewData getPreviewData() {
        return this.previewData;
    }

    public List<SkinPart> getParts() {
        return this.parts;
    }

    public List<SkinAnimation> getAnimations() {
        return this.animations;
    }

    public SkinItemTransforms getItemTransforms() {
        return this.settings.getItemTransforms();
    }

    public String getCustomName() {
        return this.properties.get(SkinProperty.ALL_CUSTOM_NAME);
    }

    public String getAuthorName() {
        return this.properties.get(SkinProperty.ALL_AUTHOR_NAME);
    }

    public String getAuthorUUID() {
        return this.properties.get(SkinProperty.ALL_AUTHOR_UUID);
    }

    public String getFlavourText() {
        return this.properties.get(SkinProperty.ALL_FLAVOUR_TEXT);
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        String returnString = "Skin [properties=" + String.valueOf(this.properties) + ", type=" + String.valueOf(this.skinType.getRegistryName());
        if (this.paintData != null) {
            returnString = returnString + ", paintData=" + String.valueOf(this.paintData);
        }
        returnString = returnString + "]";
        return returnString;
    }

    public Collection<SkinMarker> getMarkers() {
        ArrayList<SkinMarker> markers = new ArrayList<SkinMarker>();
        for (SkinPart part : this.parts) {
            markers.addAll(part.getMarkers());
        }
        return markers;
    }

    public Object getBlobs() {
        return this.blobs;
    }

    public static class Builder {
        private final ISkinType skinType;
        private final ArrayList<SkinPart> skinParts = new ArrayList();
        private final ArrayList<SkinAnimation> skinAnimations = new ArrayList();
        private SkinPaintData paintData;
        private SkinPreviewData previewData;
        private SkinSettings settings = new SkinSettings();
        private SkinProperties properties = SkinProperties.EMPTY;
        private Object blobs;
        private int version = 13;

        public Builder(ISkinType skinType) {
            this.skinType = skinType;
            if (this.skinType == SkinTypes.OUTFIT) {
                this.settings.setEditable(false);
            }
        }

        public Builder properties(SkinProperties properties) {
            if (properties != null) {
                this.properties = properties;
            }
            return this;
        }

        public Builder settings(SkinSettings settings) {
            if (settings != null) {
                this.settings = settings;
            }
            return this;
        }

        public Builder paintData(SkinPaintData paintData) {
            this.paintData = paintData;
            return this;
        }

        public Builder animations(List<SkinAnimation> animations) {
            if (animations != null) {
                this.skinAnimations.addAll(animations);
            }
            return this;
        }

        public Builder previewData(SkinPreviewData previewData) {
            this.previewData = previewData;
            return this;
        }

        public Builder parts(Collection<SkinPart> parts) {
            if (parts != null) {
                this.skinParts.addAll(parts);
            }
            return this;
        }

        public Builder blobs(Object blobs) {
            this.blobs = blobs;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Skin build() {
            this.updateSettingIfNeeded();
            this.updatePropertiesIfNeeded();
            this.bindPropertiesIfNeeded();
            Skin skin = new Skin(this.skinType, this.properties, this.settings, this.paintData, this.previewData, this.skinAnimations, this.skinParts);
            skin.version = this.version;
            skin.blobs = this.blobs;
            return skin;
        }

        private void updateSettingIfNeeded() {
            this.settings.setPreviewMode(this.previewData != null && this.skinParts.isEmpty());
        }

        private void updatePropertiesIfNeeded() {
            if (this.properties.get(SkinProperty.OVERRIDE_MODEL_ALL).booleanValue()) {
                if (this.skinType == SkinTypes.ARMOR_HEAD) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_HEAD, true);
                }
                if (this.skinType == SkinTypes.ARMOR_CHEST) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_CHEST, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_LEFT_ARM, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, true);
                }
                if (this.skinType == SkinTypes.ARMOR_LEGS) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, true);
                }
                if (this.skinType == SkinTypes.ARMOR_FEET) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, true);
                }
                this.properties.remove(SkinProperty.OVERRIDE_MODEL_ALL);
            }
            if (this.properties.get(SkinProperty.OVERRIDE_OVERLAY_ALL).booleanValue()) {
                if (this.skinType == SkinTypes.ARMOR_HEAD) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_HAT, true);
                }
                if (this.skinType == SkinTypes.ARMOR_CHEST) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_JACKET, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, true);
                }
                if (this.skinType == SkinTypes.ARMOR_LEGS) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, true);
                }
                if (this.skinType == SkinTypes.ARMOR_FEET) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, true);
                }
                this.properties.remove(SkinProperty.OVERRIDE_OVERLAY_ALL);
            }
            if (!this.properties.get(SkinProperty.OVERRIDE_OVERLAY_COLOR).booleanValue()) {
                this.properties.put(SkinProperty.KEEP_OVERLAY_COLOR, true);
                this.properties.remove(SkinProperty.OVERRIDE_OVERLAY_COLOR);
            }
        }

        private void bindPropertiesIfNeeded() {
            for (SkinPart part : this.skinParts) {
                part.setProperties(this.properties);
            }
            String skinIndexs = this.properties.get(SkinProperty.OUTFIT_PART_INDEXS);
            if (skinIndexs != null && !skinIndexs.equals("")) {
                String[] split = skinIndexs.split(":");
                int partIndex = 0;
                for (int skinIndex = 0; skinIndex < split.length; ++skinIndex) {
                    SkinProperties stub = this.properties.slice(skinIndex);
                    int count = Integer.parseInt(split[skinIndex]);
                    while (partIndex < count) {
                        if (partIndex < this.skinParts.size()) {
                            SkinPart skinPart = this.skinParts.get(partIndex);
                            skinPart.setProperties(stub);
                        }
                        ++partIndex;
                    }
                    partIndex = count;
                }
            }
        }
    }
}

