/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.List;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.skin.ISkinArmorType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinToolType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class SkinType
implements ISkinType {
    protected final String name;
    protected final int id;
    protected IResourceLocation registryName;
    protected List<? extends ISkinPartType> parts;

    public SkinType(String name, int id, List<? extends ISkinPartType> parts) {
        this.parts = parts;
        this.name = name;
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.registryName.toString();
    }

    @Override
    public IResourceLocation getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(IResourceLocation registryName) {
        this.registryName = registryName;
    }

    public String toString() {
        return ObjectUtils.makeDescription(this, "id", this.id, "name", this.registryName);
    }

    @Override
    public List<? extends ISkinPartType> getParts() {
        return this.parts;
    }

    public static class Tool
    extends SkinType
    implements ISkinToolType {
        protected Predicate<ItemStack> predicate;

        public Tool(String name, int id, List<? extends ISkinPartType> parts, Predicate<ItemStack> predicate) {
            super(name, id, parts);
            this.predicate = predicate;
        }

        @Override
        public boolean contains(ItemStack itemStack) {
            return this.predicate.test(itemStack);
        }
    }

    public static class Armor
    extends SkinType
    implements ISkinArmorType {
        protected EquipmentSlot slotType;

        public Armor(String name, int id, EquipmentSlot slotType, List<? extends ISkinPartType> parts) {
            super(name, id, parts);
            this.slotType = slotType;
        }

        @Override
        public EquipmentSlot getSlotType() {
            return this.slotType;
        }
    }
}

