/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.animation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationFunction;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;

public class SkinAnimationValue {
    private final float time;
    private final String key;
    private final SkinAnimationFunction function;
    private final List<Object> points;

    public SkinAnimationValue(float time, String key, SkinAnimationFunction function, List<Object> points) {
        this.time = time;
        this.key = key;
        this.function = function;
        this.points = points;
    }

    public static SkinAnimationValue readFromStream(String key, IInputStream stream) throws IOException {
        float time = stream.readFloat();
        SkinAnimationFunction function = SkinAnimationFunction.readFromStream(stream);
        int length = stream.readVarInt();
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < length && i < 6; ++i) {
            int flags = stream.readVarInt();
            if ((flags & 0x40) != 0) {
                objects.add(stream.readString());
                continue;
            }
            objects.add(Float.valueOf(stream.readFloat()));
        }
        return new SkinAnimationValue(time, key, function, objects);
    }

    public void writeToStream(String key, IOutputStream stream) throws IOException {
        stream.writeFloat(this.time);
        this.function.writeToStream(stream);
        stream.writeVarInt(this.points.size());
        for (Object obj : this.points) {
            if (obj instanceof String) {
                String script = (String)obj;
                stream.writeVarInt(64);
                stream.writeString(script);
                continue;
            }
            if (obj instanceof Number) {
                Number number = (Number)obj;
                stream.writeVarInt(0);
                stream.writeFloat(number.floatValue());
                continue;
            }
            stream.writeVarInt(0);
            stream.writeFloat(0.0f);
        }
    }

    public float getTime() {
        return this.time;
    }

    public String getKey() {
        return this.key;
    }

    public SkinAnimationFunction getFunction() {
        return this.function;
    }

    public List<Object> getPoints() {
        return this.points;
    }
}

