/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentAnimation;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.SkinCipher;
import org.jetbrains.annotations.Nullable;

public class SkinDocumentImporter {
    private final SkinDocument document;

    public SkinDocumentImporter(SkinDocument document) {
        this.document = document;
    }

    public void execute(String identifier, Skin skin) {
        List<SkinPart> parts = skin.getParts();
        SkinDocumentNode root = this.document.getRoot();
        for (int i = 0; i < parts.size(); ++i) {
            SkinDocumentNode node;
            SkinPart part = parts.get(i);
            if (this.isEmpty(part) || (node = this.findNodeByType(root, part.getType())) == null) continue;
            this.copyTo(part, node, identifier, String.valueOf(i));
        }
        this.copyAnimations(identifier, skin);
    }

    private void copyTo(SkinPart part, SkinDocumentNode node, String identifier, String indexPath) {
        SkinDocumentNode floatNode;
        String ref = SkinCipher.getInstance().encrypt(identifier, indexPath);
        SkinDescriptor descriptor = new SkinDescriptor(DataDomain.SLICE_LOAD.normalize(ref), SkinTypes.ADVANCED);
        if (node.isBasic()) {
            node.setSkin(descriptor);
            return;
        }
        String name = part.getName();
        if (name == null || name.isEmpty()) {
            name = "untitled node";
        }
        if (name.equals("Float") && (floatNode = this.findNodeByType(this.document.getRoot(), SkinPartTypes.ADVANCED_FLOAT)) != null) {
            node = floatNode;
            name = "untitled float node";
        }
        SkinDocumentNode newValue = new SkinDocumentNode(name);
        newValue.setSkin(descriptor);
        node.add(newValue);
    }

    private void copyAnimations(String identifier, Skin skin) {
        ArrayList<SkinDocumentAnimation> animations = new ArrayList<SkinDocumentAnimation>();
        SkinDescriptor descriptor = new SkinDescriptor(identifier, SkinTypes.ADVANCED);
        for (SkinAnimation animation : skin.getAnimations()) {
            animations.add(new SkinDocumentAnimation(animation.getName(), descriptor));
        }
        this.document.setAnimations(animations);
    }

    private boolean isEmpty(SkinPart part) {
        int cubeTotal = part.getCubeData().getCubeTotal();
        if (cubeTotal != 0) {
            return false;
        }
        for (SkinPart child : part.getParts()) {
            if (this.isEmpty(child)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private SkinDocumentNode findNodeByType(SkinDocumentNode root, ISkinPartType partType) {
        if (partType != SkinPartTypes.ADVANCED) {
            for (SkinDocumentNode node : root.children()) {
                if (!partType.equals(node.getType())) continue;
                return node;
            }
        }
        if (partType != SkinPartTypes.ADVANCED_STATIC) {
            return this.findNodeByType(root, SkinPartTypes.ADVANCED_STATIC);
        }
        return null;
    }
}

